/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.classmetrics.CouplingVisitor;
import org.jetbrains.annotations.NotNull;

public final class ClassCouplingInspection
extends ClassMetricInspection {
    private static final int DEFAULT_COUPLING_LIMIT = 15;
    public boolean m_includeJavaClasses = false;
    public boolean m_includeLibraryClasses = false;

    @NotNull
    public String getID() {
        return "OverlyCoupledClass";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer totalDependencies = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("overly.coupled.class.problem.descriptor", totalDependencies);
        if (string == null) {
            ClassCouplingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 15;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("overly.coupled.class.class.coupling.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)this.getConfigurationLabel(), (int)1, (int)1000), OptPane.checkbox((String)"m_includeJavaClasses", (String)InspectionGadgetsBundle.message("include.java.system.classes.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_includeLibraryClasses", (String)InspectionGadgetsBundle.message("include.library.classes.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ClassCouplingInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ClassCouplingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/ClassCouplingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassCouplingVisitor
    extends BaseInspectionVisitor {
        private ClassCouplingVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int totalDependencies;
            if (aClass == null) {
                ClassCouplingVisitor.$$$reportNull$$$0(0);
            }
            if ((totalDependencies = this.calculateTotalDependencies(aClass)) <= ClassCouplingInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalDependencies);
        }

        private int calculateTotalDependencies(PsiClass aClass) {
            CouplingVisitor visitor2 = new CouplingVisitor(aClass, ClassCouplingInspection.this.m_includeJavaClasses, ClassCouplingInspection.this.m_includeLibraryClasses);
            aClass.accept((PsiElementVisitor)visitor2);
            return visitor2.getNumDependencies();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ClassCouplingInspection$ClassCouplingVisitor", "visitClass"));
        }
    }
}

