/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public final class FieldCountInspection
extends ClassMetricInspection {
    private static final int FIELD_COUNT_LIMIT = 10;
    public boolean m_countConstantFields = false;
    public boolean m_considerStaticFinalFieldsConstant = false;
    public boolean myCountEnumConstants = false;

    @NotNull
    public String getID() {
        return "ClassWithTooManyFields";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("too.many.fields.problem.descriptor", infos[0]);
        if (string == null) {
            FieldCountInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("too.many.fields.count.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)this.getConfigurationLabel(), (int)1, (int)1000), OptPane.checkbox((String)"m_countConstantFields", (String)InspectionGadgetsBundle.message("field.count.inspection.include.constant.fields.in.count.checkbox", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_considerStaticFinalFieldsConstant", (String)InspectionGadgetsBundle.message("field.count.inspection.static.final.fields.count.as.constant.checkbox", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myCountEnumConstants", (String)InspectionGadgetsBundle.message("field.count.inspection.include.enum.constants.in.count", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            FieldCountInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FieldCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/FieldCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class FieldCountVisitor
    extends BaseInspectionVisitor {
        private FieldCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int totalFields;
            if (aClass == null) {
                FieldCountVisitor.$$$reportNull$$$0(0);
            }
            if ((totalFields = this.countFields(aClass)) <= FieldCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalFields);
        }

        private int countFields(PsiClass aClass) {
            PsiField[] fields;
            int totalFields = 0;
            for (PsiField field : fields = aClass.getFields()) {
                if (field instanceof PsiEnumConstant) {
                    if (!FieldCountInspection.this.myCountEnumConstants) continue;
                    ++totalFields;
                    continue;
                }
                if (!FieldCountInspection.this.m_countConstantFields && this.fieldIsConstant(field)) continue;
                ++totalFields;
            }
            return totalFields;
        }

        private boolean fieldIsConstant(PsiField field) {
            if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
                return false;
            }
            if (FieldCountInspection.this.m_considerStaticFinalFieldsConstant) {
                return true;
            }
            return ClassUtils.isImmutable(field.getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/FieldCountInspection$FieldCountVisitor", "visitClass"));
        }
    }
}

