/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class UseOfCloneInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object errorElement = infos[0];
        if (errorElement instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("use.of.clone.call.problem.descriptor", new Object[0]);
            if (string == null) {
                UseOfCloneInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (errorElement instanceof PsiMethod) {
            String string = InspectionGadgetsBundle.message("use.of.clone.call.method.problem.descriptor", new Object[0]);
            if (string == null) {
                UseOfCloneInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("use.of.clone.reference.problem.descriptor", new Object[0]);
        if (string == null) {
            UseOfCloneInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfCloneVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/UseOfCloneInspection", "buildErrorString"));
    }

    private static class UseOfCloneVisitor
    extends BaseInspectionVisitor {
        private UseOfCloneVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiType type;
            if (expression == null) {
                UseOfCloneVisitor.$$$reportNull$$$0(0);
            }
            if (!CloneUtils.isCallToClone(expression)) {
                return;
            }
            PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
            if (qualifierExpression != null && (type = qualifierExpression.getType()) instanceof PsiArrayType) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            PsiElement target;
            if (expression == null) {
                UseOfCloneVisitor.$$$reportNull$$$0(1);
            }
            if (!((target = expression.resolve()) instanceof PsiMethod) || !CloneUtils.isClone((PsiMethod)target) || PsiUtil.isArrayClass((PsiElement)((PsiMethod)target).getContainingClass())) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            String qualifiedName;
            if (reference == null) {
                UseOfCloneVisitor.$$$reportNull$$$0(2);
            }
            if (!"java.lang.Cloneable".equals(qualifiedName = reference.getQualifiedName())) {
                return;
            }
            this.registerError((PsiElement)reference, reference);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                UseOfCloneVisitor.$$$reportNull$$$0(3);
            }
            if (!CloneUtils.isClone(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/cloneable/UseOfCloneInspection$UseOfCloneVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

