/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoubleNegationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.negation.problem.descriptor", new Object[0]);
        if (string == null) {
            DoubleNegationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new DoubleNegationFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    public static boolean isNegation(@Nullable PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiPrefixExpression) {
            return DoubleNegationInspection.isUnaryNegation((PsiPrefixExpression)expression);
        }
        if (expression instanceof PsiPolyadicExpression) {
            return DoubleNegationInspection.isBinaryNegation((PsiPolyadicExpression)expression);
        }
        return false;
    }

    static boolean isUnaryNegation(PsiPrefixExpression expression) {
        return JavaTokenType.EXCL.equals(expression.getOperationTokenType());
    }

    static boolean isBinaryNegation(PsiPolyadicExpression expression) {
        PsiExpression[] operands = expression.getOperands();
        if (operands.length == 1) {
            return false;
        }
        for (PsiExpression operand : operands) {
            if (!TypeUtils.hasFloatingPointType(operand)) continue;
            return false;
        }
        return JavaTokenType.NE.equals(expression.getOperationTokenType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection", "buildErrorString"));
    }

    private static class DoubleNegationFix
    extends PsiUpdateModCommandQuickFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("double.negation.quickfix", new Object[0]);
            if (string == null) {
                DoubleNegationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement expression, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                DoubleNegationFix.$$$reportNull$$$0(1);
            }
            if (expression == null) {
                DoubleNegationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                DoubleNegationFix.$$$reportNull$$$0(3);
            }
            CommentTracker tracker = new CommentTracker();
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpression.getOperand());
                PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, BoolUtils.getNegatedExpressionText(operand, tracker), tracker);
            } else if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = polyadicExpression.getOperands();
                int length = operands.length;
                if (length == 2) {
                    PsiExpression firstOperand = operands[0];
                    PsiExpression secondOperand = operands[1];
                    if (DoubleNegationInspection.isNegation(firstOperand)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, BoolUtils.getNegatedExpressionText(firstOperand, tracker) + "==" + tracker.text((PsiElement)secondOperand), tracker);
                    } else {
                        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, tracker.text((PsiElement)firstOperand) + "==" + BoolUtils.getNegatedExpressionText(secondOperand, tracker), tracker);
                    }
                } else {
                    StringBuilder newExpressionText = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            if (length % 2 != 1 && i == length - 1) {
                                newExpressionText.append("!=");
                            } else {
                                newExpressionText.append("==");
                            }
                        }
                        newExpressionText.append(tracker.text((PsiElement)operands[i]));
                    }
                    PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString(), tracker);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            PsiExpression nestedPrefixOperand;
            if (expression == null) {
                DoubleNegationVisitor.$$$reportNull$$$0(0);
            }
            super.visitPrefixExpression(expression);
            if (!DoubleNegationInspection.isUnaryNegation(expression)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (!DoubleNegationInspection.isNegation(operand)) {
                return;
            }
            PsiExpression nestedOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand);
            if (nestedOperand instanceof PsiPrefixExpression && ((nestedPrefixOperand = ((PsiPrefixExpression)nestedOperand).getOperand()) == null || !LambdaUtil.isSafeLambdaReturnValueReplacement((PsiExpression)expression, (PsiExpression)nestedPrefixOperand))) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                DoubleNegationVisitor.$$$reportNull$$$0(1);
            }
            super.visitPolyadicExpression(expression);
            if (!DoubleNegationInspection.isBinaryNegation(expression)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            if (operands.length == 2) {
                int notNegatedCount = 0;
                for (PsiExpression operand : operands) {
                    if (DoubleNegationInspection.isNegation(operand)) continue;
                    ++notNegatedCount;
                }
                if (notNegatedCount > 1) {
                    return;
                }
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

