/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NavigateToDuplicateExpressionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicateConditionInspection
extends BaseInspection {
    public boolean ignoreSideEffectConditions = true;
    private static final int LIMIT_DEPTH = 20;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("duplicate.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            DuplicateConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSideEffectConditions", (String)InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option.description", new Object[0]))});
        if (optPane == null) {
            DuplicateConditionInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        Object object = ArrayUtil.getFirstElement((Object[])infos);
        if (object instanceof PsiExpression) {
            PsiExpression duplicate = (PsiExpression)object;
            return new NavigateToDuplicateExpressionFix(duplicate);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/DuplicateConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private final Set<PsiIfStatement> myAnalyzedAndStatements = new HashSet<PsiIfStatement>();
        private final Set<PsiIfStatement> myAnalyzedOrStatements = new HashSet<PsiIfStatement>();

        private DuplicateConditionVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiIfStatement parentIf;
            PsiBlockStatement blockStatement;
            PsiElement psiElement;
            PsiCodeBlock codeBlock;
            if (statement == null) {
                DuplicateConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            if (ControlFlowUtils.isElseIf(statement)) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                return;
            }
            if (parent instanceof PsiCodeBlock && ArrayUtil.getFirstElement((Object[])(codeBlock = (PsiCodeBlock)parent).getStatements()) == statement && (psiElement = parent.getParent()) instanceof PsiBlockStatement && (psiElement = (blockStatement = (PsiBlockStatement)psiElement).getParent()) instanceof PsiIfStatement && (parentIf = (PsiIfStatement)psiElement).getThenBranch() == blockStatement) {
                return;
            }
            LinkedHashSet<PsiExpression> conditions = new LinkedHashSet<PsiExpression>();
            this.collectConditionsForIfStatementOrChain(statement, conditions, 0);
            if (conditions.size() >= 2) {
                this.findDuplicatesAccordingToSideEffects(conditions);
            }
            conditions.clear();
            this.collectConditionsForIfStatementAndChain(statement, conditions, 0);
            if (conditions.size() >= 2) {
                this.findDuplicatesAccordingToSideEffects(conditions);
            }
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            PsiBinaryExpression parentExpression;
            if (expression == null) {
                DuplicateConditionVisitor.$$$reportNull$$$0(1);
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
            if (parent instanceof PsiIfStatement) {
                return;
            }
            if (parent instanceof PsiBinaryExpression && tokenType.equals((parentExpression = (PsiBinaryExpression)parent).getOperationTokenType())) {
                return;
            }
            LinkedHashSet<PsiExpression> conditions = new LinkedHashSet<PsiExpression>();
            DuplicateConditionVisitor.collectConditionsForExpression((PsiExpression)expression, conditions, tokenType);
            if (conditions.size() < 2) {
                return;
            }
            this.findDuplicatesAccordingToSideEffects(conditions);
        }

        private void collectConditionsForIfStatementAndChain(PsiIfStatement statement, Set<? super PsiExpression> conditions, int depth) {
            if (depth > 20 || !this.myAnalyzedAndStatements.add(statement)) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            DuplicateConditionVisitor.collectConditionsForExpression(condition, conditions, JavaTokenType.ANDAND);
            PsiStatement branch = ControlFlowUtils.stripBraces(statement.getThenBranch());
            if (branch instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)branch;
                this.collectConditionsForIfStatementAndChain(ifStatement, conditions, depth + 1);
            }
            if (branch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)branch;
                PsiStatement[] statements = blockStatement.getCodeBlock().getStatements();
                if (statements.length == 0) {
                    return;
                }
                PsiStatement psiStatement = statements[0];
                if (psiStatement instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)psiStatement;
                    this.collectConditionsForIfStatementAndChain(ifStatement, conditions, depth + 1);
                }
            }
        }

        private void collectConditionsForIfStatementOrChain(PsiIfStatement statement, Set<? super PsiExpression> conditions, int depth) {
            if (depth > 20 || !this.myAnalyzedOrStatements.add(statement)) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            DuplicateConditionVisitor.collectConditionsForExpression(condition, conditions, JavaTokenType.OROR);
            PsiStatement branch = ControlFlowUtils.stripBraces(statement.getElseBranch());
            if (branch instanceof PsiIfStatement) {
                this.collectConditionsForIfStatementOrChain((PsiIfStatement)branch, conditions, depth + 1);
            }
            if (branch == null) {
                PsiStatement thenBranch = statement.getThenBranch();
                if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                    return;
                }
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement);
                if (next instanceof PsiIfStatement) {
                    this.collectConditionsForIfStatementOrChain((PsiIfStatement)next, conditions, depth + 1);
                }
            }
        }

        private static void collectConditionsForExpression(PsiExpression condition, Set<? super PsiExpression> conditions, IElementType wantedTokenType) {
            PsiExpression negated;
            PsiPolyadicExpression polyadicExpression;
            IElementType tokenType;
            if ((condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)) == null) {
                return;
            }
            if (condition instanceof PsiPolyadicExpression && wantedTokenType.equals(tokenType = (polyadicExpression = (PsiPolyadicExpression)condition).getOperationTokenType())) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    DuplicateConditionVisitor.collectConditionsForExpression(operand, conditions, wantedTokenType);
                }
                return;
            }
            while ((negated = BoolUtils.getNegated(condition)) != null) {
                condition = negated;
            }
            conditions.add((PsiExpression)condition);
        }

        private void findDuplicatesAccordingToSideEffects(Set<PsiExpression> conditions) {
            ArrayList<PsiExpression> conditionList = new ArrayList<PsiExpression>(conditions);
            ThreeState wantedStatus = DuplicateConditionInspection.this.ignoreSideEffectConditions ? ThreeState.UNSURE : ThreeState.YES;
            conditionList.replaceAll(cond -> SideEffectChecker.getSideEffectStatus(cond).isAtLeast(wantedStatus) ? null : cond);
            ((StreamEx)StreamEx.of(conditionList).groupRuns((a, b) -> a != null && b != null).filter(list -> list.size() >= 2)).forEach(this::findDuplicates);
        }

        private void findDuplicates(List<PsiExpression> conditions) {
            BitSet matched = new BitSet();
            for (int i = 0; i < conditions.size(); ++i) {
                if (matched.get(i)) continue;
                PsiExpression condition = conditions.get(i);
                for (int j = i + 1; j < conditions.size(); ++j) {
                    if (matched.get(j)) continue;
                    PsiExpression testCondition = conditions.get(j);
                    boolean areEquivalent = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(condition, testCondition);
                    if (!areEquivalent) continue;
                    this.registerError((PsiElement)testCondition, condition);
                    if (!matched.get(i)) {
                        this.registerError((PsiElement)condition, testCondition);
                    }
                    matched.set(i);
                    matched.set(j);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/DuplicateConditionInspection$DuplicateConditionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

