/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SimplifiableEqualsExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean REPORT_NON_CONSTANT = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"REPORT_NON_CONSTANT", (String)InspectionGadgetsBundle.message("simplifiable.equals.expression.option.non.constant", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SimplifiableEqualsExpressionInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("simplifiable.equals.expression.problem.descriptor", infos[0]);
        if (string == null) {
            SimplifiableEqualsExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SimplifiableEqualsExpressionFix((String)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableEqualsExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SimplifiableEqualsExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private final String myMethodName;

        SimplifiableEqualsExpressionFix(String methodName) {
            this.myMethodName = methodName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("simplifiable.equals.expression.quickfix", this.myMethodName);
            if (string == null) {
                SimplifiableEqualsExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                SimplifiableEqualsExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                SimplifiableEqualsExpressionFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                SimplifiableEqualsExpressionFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                SimplifiableEqualsExpressionFix.$$$reportNull$$$0(4);
            }
            if (!((parent = ParenthesesUtils.getParentSkipParentheses(element)) instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length != 2) {
                return;
            }
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[1]);
            @NonNls StringBuilder newExpressionText = new StringBuilder();
            if (operand instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)operand;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return;
                }
                newExpressionText.append('!');
                operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpression.getOperand());
            }
            if (!(operand instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            if (PsiTypes.booleanType().equals((Object)type)) {
                Object value = ExpressionUtils.computeConstantExpression(argument);
                if (Boolean.TRUE.equals(value)) {
                    newExpressionText.append("java.lang.Boolean.TRUE");
                } else if (Boolean.FALSE.equals(value)) {
                    newExpressionText.append("java.lang.Boolean.FALSE");
                } else {
                    newExpressionText.append("java.lang.Boolean.valueOf(").append(argument.getText()).append(')');
                }
            } else if (PsiTypes.byteType().equals((Object)type)) {
                newExpressionText.append("java.lang.Byte.valueOf(").append(argument.getText()).append(')');
            } else if (PsiTypes.shortType().equals((Object)type)) {
                newExpressionText.append("java.lang.Short.valueOf(").append(argument.getText()).append(')');
            } else if (PsiTypes.intType().equals((Object)type)) {
                newExpressionText.append("java.lang.Integer.valueOf(").append(argument.getText()).append(')');
            } else if (PsiTypes.longType().equals((Object)type)) {
                newExpressionText.append("java.lang.Long.valueOf(").append(argument.getText()).append(')');
            } else if (PsiTypes.floatType().equals((Object)type)) {
                newExpressionText.append("java.lang.Float.valueOf(").append(argument.getText()).append(')');
            } else if (PsiTypes.doubleType().equals((Object)type)) {
                newExpressionText.append("java.lang.Double.valueOf(").append(argument.getText()).append(')');
            } else {
                newExpressionText.append(argument.getText());
            }
            newExpressionText.append('.').append(referenceName).append('(').append(qualifier.getText()).append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection$SimplifiableEqualsExpressionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection$SimplifiableEqualsExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class SimplifiableEqualsExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableEqualsExpressionVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                SimplifiableEqualsExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                PsiExpression[] operands = expression.getOperands();
                if (operands.length != 2) {
                    return;
                }
                PsiExpression lhs = operands[0];
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(lhs, false);
                if (variable == null) {
                    return;
                }
                PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[1]);
                if (!this.isEqualsConstant(rhs, variable)) {
                    return;
                }
                this.registerError((PsiElement)lhs, SimplifiableEqualsExpressionVisitor.getMethodName((PsiMethodCallExpression)rhs));
            } else if (JavaTokenType.OROR.equals(tokenType)) {
                PsiExpression[] operands = expression.getOperands();
                if (operands.length != 2) {
                    return;
                }
                PsiExpression lhs = operands[0];
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(lhs, true);
                if (variable == null) {
                    return;
                }
                PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[1]);
                if (!(rhs instanceof PsiPrefixExpression)) {
                    return;
                }
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)rhs;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return;
                }
                PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpression.getOperand());
                if (!this.isEqualsConstant(operand, variable)) {
                    return;
                }
                this.registerError((PsiElement)lhs, SimplifiableEqualsExpressionVisitor.getMethodName((PsiMethodCallExpression)operand));
            }
        }

        private static String getMethodName(PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            return methodExpression.getReferenceName();
        }

        private boolean isEqualsConstant(PsiExpression expression, PsiVariable variable) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName) && !"equalsIgnoreCase".equals(methodName)) {
                return false;
            }
            if (!ExpressionUtils.isReferenceTo(methodExpression.getQualifierExpression(), variable)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            if (PsiUtil.isConstantExpression((PsiExpression)argument)) {
                return true;
            }
            return SimplifiableEqualsExpressionInspection.this.REPORT_NON_CONSTANT && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)argument) && !SideEffectChecker.mayHaveSideEffects(argument) && !CommonDataflow.getDfType(argument).isSuperType((DfType)DfTypes.NULL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection$SimplifiableEqualsExpressionVisitor", "visitPolyadicExpression"));
        }
    }
}

