/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryReturnInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreInThenBranch = false;

    @NotNull
    public String getID() {
        return "UnnecessaryReturnStatement";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("unnecessary.return.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryReturnInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.return.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInThenBranch", (String)InspectionGadgetsBundle.message("unnecessary.return.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("return");
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(3);
        }
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryReturnVisitor();
    }

    public static boolean isReturnRedundant(@NotNull PsiReturnStatement statement, boolean ignoreInThenBranch, boolean checkReturnType, @Nullable Ref<? super Boolean> isInConstructorRef) {
        if (statement == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(4);
        }
        if (statement.getReturnValue() != null) {
            return false;
        }
        PsiElement methodParent = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        PsiCodeBlock codeBlock = null;
        if (methodParent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)methodParent;
            codeBlock = method.getBody();
            if (isInConstructorRef != null) {
                isInConstructorRef.set((Object)method.isConstructor());
            }
            if (checkReturnType && !method.isConstructor() && !PsiTypes.voidType().equals((Object)method.getReturnType())) {
                return false;
            }
        } else if (methodParent instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)methodParent;
            if (isInConstructorRef != null) {
                isInConstructorRef.set((Object)false);
            }
            if (checkReturnType && !PsiTypes.voidType().equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression))) {
                return false;
            }
            PsiElement lambdaBody = lambdaExpression.getBody();
            if (lambdaBody instanceof PsiCodeBlock) {
                codeBlock = (PsiCodeBlock)lambdaBody;
            }
        } else {
            return false;
        }
        if (codeBlock == null) {
            return false;
        }
        if (!ControlFlowUtils.blockCompletesWithStatement(codeBlock, (PsiStatement)statement) || ControlFlowUtils.isInFinallyBlock((PsiElement)statement, null)) {
            return false;
        }
        return !ignoreInThenBranch || !UnnecessaryReturnInspection.isInThenBranch((PsiStatement)statement);
    }

    static boolean isInThenBranch(PsiStatement statement) {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (ifStatement == null) {
            return false;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch != null && !PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)statement, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/UnnecessaryReturnInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/UnnecessaryReturnInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReturnRedundant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private class UnnecessaryReturnVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryReturnVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                UnnecessaryReturnVisitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(statement);
            Ref constructorRef = Ref.create();
            if (UnnecessaryReturnInspection.isReturnRedundant(statement, UnnecessaryReturnInspection.this.ignoreInThenBranch, true, (Ref<? super Boolean>)constructorRef)) {
                this.registerError(statement.getFirstChild(), constructorRef.get());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection$UnnecessaryReturnVisitor", "visitReturnStatement"));
        }
    }
}

