/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public final class LawOfDemeterInspection
extends BaseInspection {
    public boolean ignoreLibraryCalls = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean isMethodCall = (Boolean)infos[0];
        String string = isMethodCall ? InspectionGadgetsBundle.message("law.of.demeter.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("law.of.demeter.field.problem.descriptor", new Object[0]);
        if (string == null) {
            LawOfDemeterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreLibraryCalls", (String)InspectionGadgetsBundle.message("law.of.demeter.ignore.library.calls.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            LawOfDemeterInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LawOfDemeterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/LawOfDemeterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LawOfDemeterVisitor
    extends BaseInspectionVisitor {
        private LawOfDemeterVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                LawOfDemeterVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiExpression qualifier = expression.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!this.isCallToSuspiciousMethod(expression)) {
                return;
            }
            if (this.violatesLawOfDemeter(qualifier)) {
                this.registerMethodCallError(expression, Boolean.TRUE);
            }
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                LawOfDemeterVisitor.$$$reportNull$$$0(1);
            }
            super.visitReferenceExpression(expression);
            if (expression.getParent() instanceof PsiMethodCallExpression) {
                return;
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiElement nameElement = expression.getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            if (this.violatesLawOfDemeter(qualifier)) {
                this.registerError(nameElement, Boolean.FALSE);
            }
        }

        private boolean isCallToSuspiciousMethod(PsiMethodCallExpression expression) {
            PsiMethod method = expression.resolveMethod();
            if (method == null || MethodUtils.isFactoryMethod(method)) {
                return false;
            }
            if (LawOfDemeterInspection.this.ignoreLibraryCalls && method instanceof PsiCompiledElement) {
                return false;
            }
            if (method.getContainingFile() == expression.getContainingFile()) {
                return false;
            }
            PsiType type = method.getReturnType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            return method.getContainingClass() != aClass;
        }

        public boolean violatesLawOfDemeter(PsiExpression expression) {
            PsiMethodCallExpression methodCallExpression;
            PsiElement qualifier = PsiUtil.skipParenthesizedExprUp((PsiElement)expression);
            if (qualifier instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (target instanceof PsiParameter) {
                    return false;
                }
                if (target instanceof PsiField) {
                    PsiField field = (PsiField)target;
                    if (field.hasModifierProperty("static")) {
                        return false;
                    }
                    if (field.getContainingFile() == expression.getContainingFile()) {
                        return false;
                    }
                    return !LawOfDemeterInspection.this.ignoreLibraryCalls || !(field instanceof PsiCompiledElement);
                }
                if (target instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)target;
                    if (LawOfDemeterInspection.this.ignoreLibraryCalls && variable.getType() instanceof PsiArrayType) {
                        return false;
                    }
                    PsiExpression definition = DeclarationSearchUtils.findDefinition(referenceExpression, (PsiVariable)variable);
                    return this.violatesLawOfDemeter(definition);
                }
            } else if (qualifier instanceof PsiMethodCallExpression && this.isCallToSuspiciousMethod(methodCallExpression = (PsiMethodCallExpression)qualifier)) {
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/dataflow/LawOfDemeterInspection$LawOfDemeterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

