/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class NullThrownInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("null.thrown.problem.descriptor", new Object[0]);
        if (string == null) {
            NullThrownInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ThrowNullFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowNullVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/NullThrownInspection", "buildErrorString"));
    }

    private static class ThrowNullFix
    extends PsiUpdateModCommandQuickFix {
        private ThrowNullFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{new NullPointerException()});
            if (string == null) {
                ThrowNullFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ThrowNullFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ThrowNullFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ThrowNullFix.$$$reportNull$$$0(3);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression newExpression = factory.createExpressionFromText("new java.lang.NullPointerException()", element);
            element.replace((PsiElement)newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/errorhandling/NullThrownInspection$ThrowNullFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/errorhandling/NullThrownInspection$ThrowNullFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ThrowNullVisitor
    extends BaseInspectionVisitor {
        private ThrowNullVisitor() {
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement == null) {
                ThrowNullVisitor.$$$reportNull$$$0(0);
            }
            super.visitThrowStatement(statement);
            PsiExpression exception = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getException());
            if (!(exception instanceof PsiLiteralExpression)) {
                return;
            }
            PsiType type = exception.getType();
            if (!PsiTypes.nullType().equals(type)) {
                return;
            }
            this.registerError((PsiElement)exception, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/NullThrownInspection$ThrowNullVisitor", "visitThrowStatement"));
        }
    }
}

