/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchSectionFix
extends PsiUpdateModCommandQuickFix {
    private final boolean removeTryCatch;

    public DeleteCatchSectionFix(boolean removeTryCatch) {
        this.removeTryCatch = removeTryCatch;
    }

    @NotNull
    public String getName() {
        if (this.removeTryCatch) {
            String string = CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"try-catch"});
            if (string == null) {
                DeleteCatchSectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("delete.catch.section.quickfix", new Object[0]);
        if (string == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("delete.catch.section.fix.family.name", new Object[0]);
        if (string == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiElement parent;
        if (project == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(5);
        }
        if (!((parent = element.getParent()) instanceof PsiParameter)) {
            return;
        }
        PsiParameter parameter = (PsiParameter)parent;
        PsiElement grandParent = parameter.getParent();
        if (!(grandParent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)grandParent;
        if (this.removeTryCatch) {
            BlockUtils.unwrapTryBlock((PsiTryStatement)catchSection.getTryStatement());
        } else {
            catchSection.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/DeleteCatchSectionFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/DeleteCatchSectionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

