/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeMethodFinalFix
extends PsiUpdateModCommandQuickFix {
    private final String myMethodName;

    public MakeMethodFinalFix(String methodName) {
        this.myMethodName = methodName;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.method.final.fix.name", this.myMethodName);
        if (string == null) {
            MakeMethodFinalFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("make.method.final.fix.family.name", new Object[0]);
        if (string == null) {
            MakeMethodFinalFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
        PsiElement element;
        PsiMethod method;
        if (project == null) {
            MakeMethodFinalFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            MakeMethodFinalFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            MakeMethodFinalFix.$$$reportNull$$$0(4);
        }
        if ((method = MakeMethodFinalFix.findMethodToFix(element = startElement.getParent())) != null) {
            method = (PsiMethod)updater.getWritable((PsiElement)method);
            method.getModifierList().setModifierProperty("final", true);
            if (method.getContainingFile() != element.getContainingFile()) {
                updater.moveCaretTo((PsiElement)Objects.requireNonNullElse(method.getNameIdentifier(), method));
            }
        }
    }

    @Nullable
    private static PsiMethod findMethodToFix(PsiElement element) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return method;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
            return methodCall.resolveMethod();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/MakeMethodFinalFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/MakeMethodFinalFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

