/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AbstractMethodOverridesAbstractMethodInspection
extends BaseInspection {
    public boolean ignoreJavaDoc = false;

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new AbstractMethodOverridesAbstractMethodFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.problem.descriptor", new Object[0]);
        if (string == null) {
            AbstractMethodOverridesAbstractMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreJavaDoc", (String)InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.ignore.different.javadoc.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            AbstractMethodOverridesAbstractMethodInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesAbstractMethodVisitor();
    }

    public static boolean methodsHaveSameAnnotationsAndModifiers(PsiMethod method, PsiMethod superMethod) {
        if (!MethodUtils.haveEquivalentModifierLists(method, superMethod)) {
            return false;
        }
        PsiParameter[] superParameters = superMethod.getParameterList().getParameters();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != superParameters.length) {
            return false;
        }
        int length = superParameters.length;
        for (int i = 0; i < length; ++i) {
            if (AbstractMethodOverridesAbstractMethodInspection.haveSameAnnotations((PsiModifierListOwner)parameters[i], (PsiModifierListOwner)superParameters[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean haveSameAnnotations(PsiModifierListOwner owner1, PsiModifierListOwner owner2) {
        PsiModifierList modifierList = owner1.getModifierList();
        PsiModifierList superModifierList = owner2.getModifierList();
        return modifierList == null || superModifierList == null ? modifierList == superModifierList : AnnotationUtil.equal((PsiAnnotation[])modifierList.getAnnotations(), (PsiAnnotation[])superModifierList.getAnnotations());
    }

    static boolean haveSameJavaDoc(PsiMethod method, PsiMethod superMethod) {
        PsiDocComment superDocComment = superMethod.getDocComment();
        PsiDocComment docComment = method.getDocComment();
        return !(superDocComment == null ? docComment != null : docComment != null && !superDocComment.getText().equals(docComment.getText()));
    }

    public static boolean haveSameExceptionSignatures(PsiMethod method1, PsiMethod method2) {
        PsiReferenceList list2;
        PsiClassType[] exceptions2;
        PsiReferenceList list1 = method1.getThrowsList();
        Object[] exceptions1 = list1.getReferencedTypes();
        if (exceptions1.length != (exceptions2 = (list2 = method2.getThrowsList()).getReferencedTypes()).length) {
            return false;
        }
        HashSet set1 = ContainerUtil.newHashSet((Object[])exceptions1);
        for (PsiClassType anException : exceptions2) {
            if (set1.contains(anException)) continue;
            return false;
        }
        return true;
    }

    public static boolean haveSameReturnTypes(PsiMethod method1, PsiMethod method2) {
        return AbstractMethodOverridesAbstractMethodInspection.areTypesEqual(method1.getReturnType(), method2.getReturnType());
    }

    private static boolean areTypesEqual(@Nullable PsiType type, @Nullable PsiType bound) {
        PsiClassType classType;
        block8: {
            block7: {
                PsiType boundErasure;
                if (type == null || bound == null) {
                    return false;
                }
                PsiType typeErasure = TypeConversionUtil.erasure((PsiType)type);
                if (!typeErasure.equals(boundErasure = TypeConversionUtil.erasure((PsiType)bound))) {
                    return false;
                }
                if (!(type instanceof PsiClassType)) break block7;
                classType = (PsiClassType)type;
                if (bound instanceof PsiClassType) break block8;
            }
            return true;
        }
        PsiClassType boundClassType = (PsiClassType)bound;
        PsiType[] typeParameters = classType.getParameters();
        PsiType[] boundParameters = boundClassType.getParameters();
        if (typeParameters.length != boundParameters.length) {
            return false;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            if (AbstractMethodOverridesAbstractMethodInspection.areTypesEqual(typeParameters[i], boundParameters[i])) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiSubstitutor getSuperSubstitutor(PsiMethod method, PsiMethod superMethod) {
        PsiClass contextClass = method.getContainingClass();
        PsiClass superClass = superMethod.getContainingClass();
        if (contextClass == null || superClass == null) {
            return null;
        }
        PsiSubstitutor classSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)contextClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        MethodSignature contextSignature = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignature superSignature = superMethod.getSignature(classSubstitutor);
        return MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)contextSignature, (MethodSignature)superSignature);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AbstractMethodOverridesAbstractMethodFix
    extends ModCommandQuickFix {
        private AbstractMethodOverridesAbstractMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.remove.quickfix", new Object[0]);
            if (string == null) {
                AbstractMethodOverridesAbstractMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AbstractMethodOverridesAbstractMethodFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AbstractMethodOverridesAbstractMethodFix.$$$reportNull$$$0(2);
            }
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodNameIdentifier.getParent();
            assert (method != null);
            PsiMethod[] superMethods = method.findSuperMethods();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            Collection references = ReferencesSearch.search((PsiElement)method, (SearchScope)scope).findAll();
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)method, (m, updater) -> {
                List writableRefs = ContainerUtil.map((Collection)references, ref -> updater.getWritable(ref.getElement()));
                for (PsiElement e : writableRefs) {
                    PsiReference reference = e.getReference();
                    if (reference == null) continue;
                    reference.bindToElement((PsiElement)superMethods[0]);
                }
                m.delete();
            });
            if (modCommand == null) {
                AbstractMethodOverridesAbstractMethodFix.$$$reportNull$$$0(3);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class AbstractMethodOverridesAbstractMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesAbstractMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] superMethods;
            if (method == null) {
                AbstractMethodOverridesAbstractMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor() || !method.hasModifierProperty("abstract")) {
                return;
            }
            boolean overrideDefault = false;
            boolean accept = false;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                overrideDefault |= superMethod.hasModifierProperty("default");
                if (!superMethod.hasModifierProperty("abstract")) continue;
                if (overrideDefault) {
                    return;
                }
                accept |= AbstractMethodOverridesAbstractMethodInspection.haveSameReturnTypes(method, superMethod) && AbstractMethodOverridesAbstractMethodInspection.haveSameExceptionSignatures(method, superMethod) && method.isVarArgs() == superMethod.isVarArgs();
                if (AbstractMethodOverridesAbstractMethodInspection.this.ignoreJavaDoc && !AbstractMethodOverridesAbstractMethodInspection.haveSameJavaDoc(method, superMethod)) {
                    return;
                }
                if (AbstractMethodOverridesAbstractMethodInspection.methodsHaveSameAnnotationsAndModifiers(method, superMethod)) continue;
                return;
            }
            if (accept && !overrideDefault) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodVisitor", "visitMethod"));
        }
    }
}

