/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class StaticVariableUninitializedUseInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        return "StaticVariableUsedBeforeInitialization";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.variable.used.before.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignorePrimitives", (String)InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/StaticVariableUninitializedUseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private StaticVariableInitializationVisitor() {
        }

        /*
         * WARNING - void declaration
         */
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                StaticVariableInitializationVisitor.$$$reportNull$$$0(0);
            }
            PsiField[] fields = aClass.getFields();
            if (aClass.isEnum()) {
                return;
            }
            for (PsiField field : fields) {
                void var13_17;
                PsiExpression[] moreBadReads;
                PsiType type;
                if (!field.hasModifierProperty("static") || field.getInitializer() != null || StaticVariableUninitializedUseInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(type = field.getType())) continue;
                UninitializedReadCollector uninitializedReadCollector = new UninitializedReadCollector();
                boolean assignedInInitializer = Arrays.stream(aClass.getInitializers()).filter(initializer -> initializer.hasModifierProperty("static")).map(PsiClassInitializer::getBody).anyMatch(body -> uninitializedReadCollector.blockAssignsVariable((PsiCodeBlock)body, (PsiVariable)field));
                if (assignedInInitializer) {
                    PsiExpression[] badReads;
                    for (PsiExpression psiExpression : badReads = uninitializedReadCollector.getUninitializedReads()) {
                        this.registerError((PsiElement)psiExpression, new Object[0]);
                    }
                    continue;
                }
                PsiMethod[] methods = aClass.getMethods();
                for (PsiExpression psiExpression : methods) {
                    if (!psiExpression.hasModifierProperty("static") || !psiExpression.isPhysical()) continue;
                    PsiCodeBlock body2 = psiExpression.getBody();
                    uninitializedReadCollector.blockAssignsVariable(body2, (PsiVariable)field);
                }
                PsiExpression[] psiExpressionArray = moreBadReads = uninitializedReadCollector.getUninitializedReads();
                int n = psiExpressionArray.length;
                boolean bl = false;
                while (var13_17 < n) {
                    PsiExpression badRead = psiExpressionArray[var13_17];
                    this.registerError((PsiElement)badRead, new Object[0]);
                    ++var13_17;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/initialization/StaticVariableUninitializedUseInspection$StaticVariableInitializationVisitor", "visitClass"));
        }
    }
}

