/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryUnicodeEscapeInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Character c = (Character)infos[0];
        if (c.charValue() == '\n') {
            String string = InspectionGadgetsBundle.message("unnecessary.unicode.escape.problem.newline.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryUnicodeEscapeInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.unicode.escape.problem.descriptor", c.charValue() == '\t' ? "\\t" : c);
        if (string == null) {
            UnnecessaryUnicodeEscapeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryUnicodeEscapeFix(((Character)infos[0]).charValue(), (RangeMarker)infos[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnicodeEscapeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection", "buildErrorString"));
    }

    private static class UnnecessaryUnicodeEscapeFix
    extends PsiUpdateModCommandQuickFix {
        private final char c;
        private final RangeMarker myRangeMarker;

        UnnecessaryUnicodeEscapeFix(char c, RangeMarker rangeMarker) {
            this.c = c;
            this.myRangeMarker = rangeMarker;
        }

        @NotNull
        public String getName() {
            String string = switch (this.c) {
                case '\n' -> InspectionGadgetsBundle.message("unnecessary.unicode.escape.fix.text", 1);
                case '\t' -> InspectionGadgetsBundle.message("unnecessary.unicode.escape.fix.text", 2);
                case ' ' -> InspectionGadgetsBundle.message("unnecessary.unicode.escape.fix.text", 3);
                default -> CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{Character.valueOf(this.c)});
            };
            if (string == null) {
                UnnecessaryUnicodeEscapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unicode.escape.fix.family.name", new Object[0]);
            if (string == null) {
                UnnecessaryUnicodeEscapeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessaryUnicodeEscapeFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                UnnecessaryUnicodeEscapeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UnnecessaryUnicodeEscapeFix.$$$reportNull$$$0(4);
            }
            Document document = startElement.getContainingFile().getFileDocument();
            String replacement = this.c == '\t' && PsiUtil.isJavaToken((PsiElement)startElement, (TokenSet)ElementType.STRING_LITERALS) ? "\\t" : String.valueOf(this.c);
            document.replaceString(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset(), (CharSequence)replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection$UnnecessaryUnicodeEscapeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection$UnnecessaryUnicodeEscapeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessaryUnicodeEscapeVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnicodeEscapeVisitor() {
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                UnnecessaryUnicodeEscapeVisitor.$$$reportNull$$$0(0);
            }
            super.visitFile(psiFile);
            if (InjectedLanguageManager.getInstance((Project)psiFile.getProject()).isInjectedFragment(psiFile) || !psiFile.isPhysical()) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            if (document == null) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            String text = psiFile.getText();
            Charset charset = LoadTextUtil.extractCharsetFromFileContent((Project)psiFile.getProject(), (VirtualFile)virtualFile, (CharSequence)text);
            CharsetEncoder encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer charBuffer = CharBuffer.allocate(1);
            ByteBuffer byteBuffer = ByteBuffer.allocate(10);
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                Character.UnicodeBlock block;
                int type;
                int escapeEnd;
                char d;
                int nextChar;
                char c = text.charAt(i);
                if (c != '\\') continue;
                boolean isEscape = true;
                for (int previousChar = i - 1; previousChar >= 0 && text.charAt(previousChar) == '\\'; --previousChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape || (nextChar = UnnecessaryUnicodeEscapeVisitor.detectUnicodeEscape(text, i, length)) == -1 || (d = (char)Integer.parseInt(text.substring(nextChar, escapeEnd = nextChar + 4), 16)) == '\ufffd' || d == '\\' && UnnecessaryUnicodeEscapeVisitor.detectUnicodeEscape(text, escapeEnd - 1, length) != -1 || (type = Character.getType(d)) == 15 && d != '\n' && d != '\t' || type == 12 && d != ' ' || type == 16 || type == 18 || type == 19 || type == 0 || type == 13 || type == 14 || (block = Character.UnicodeBlock.of(d)) == Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS || block == Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS_EXTENDED || block == Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS_SUPPLEMENT || block == Character.UnicodeBlock.COMBINING_HALF_MARKS || block == Character.UnicodeBlock.COMBINING_MARKS_FOR_SYMBOLS) continue;
                byteBuffer.clear();
                charBuffer.clear();
                charBuffer.put(d).rewind();
                CoderResult coderResult = encoder.encode(charBuffer, byteBuffer, true);
                if (coderResult.isError()) continue;
                PsiElement element = psiFile.findElementAt(i);
                if (element == null) {
                    return;
                }
                RangeMarker rangeMarker = document.createRangeMarker(i, escapeEnd);
                TextRange range = element.getTextRange();
                while (escapeEnd > range.getEndOffset()) {
                    element = element.getParent();
                    range = element.getTextRange();
                }
                this.registerErrorAtOffset(element, i - range.getStartOffset(), escapeEnd - i, Character.valueOf(d), rangeMarker);
            }
        }

        private static int detectUnicodeEscape(String text, int offset, int length) {
            int nextChar;
            for (nextChar = offset + 1; nextChar < length && text.charAt(nextChar) == 'u'; ++nextChar) {
            }
            if (nextChar == offset + 1 || nextChar + 3 >= length) {
                return -1;
            }
            if (StringUtil.isHexDigit((char)text.charAt(nextChar)) && StringUtil.isHexDigit((char)text.charAt(nextChar + 1)) && StringUtil.isHexDigit((char)text.charAt(nextChar + 2)) && StringUtil.isHexDigit((char)text.charAt(nextChar + 3))) {
                return nextChar;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection$UnnecessaryUnicodeEscapeVisitor", "visitFile"));
        }
    }
}

