/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.j2me.ShiftUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public final class MultiplyOrDivideByPowerOfTwoInspection
extends BaseInspection {
    public boolean checkDivision = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"checkDivision", (String)InspectionGadgetsBundle.message("multiply.or.divide.by.power.of.two.divide.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MultiplyOrDivideByPowerOfTwoInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", MultiplyOrDivideByPowerOfTwoInspection.calculateReplacementShift((PsiExpression)infos[0], new CommentTracker()));
        if (string == null) {
            MultiplyOrDivideByPowerOfTwoInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    static String calculateReplacementShift(PsiExpression expression, CommentTracker commentTracker) {
        String operator;
        PsiExpression rhs;
        PsiExpression lhs;
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression exp = (PsiAssignmentExpression)expression;
            lhs = exp.getLExpression();
            rhs = exp.getRExpression();
            IElementType tokenType = exp.getOperationTokenType();
            operator = tokenType.equals(JavaTokenType.ASTERISKEQ) ? "<<=" : ">>=";
        } else {
            PsiBinaryExpression exp = (PsiBinaryExpression)expression;
            lhs = exp.getLOperand();
            rhs = exp.getROperand();
            IElementType tokenType = exp.getOperationTokenType();
            operator = tokenType.equals(JavaTokenType.ASTERISK) ? "<<" : ">>";
        }
        if (!(rhs instanceof PsiLiteralExpression)) {
            return null;
        }
        String lhsText = commentTracker.text(lhs, 7);
        String expString = lhsText + operator + ShiftUtils.getLogBaseTwo((PsiLiteralExpression)rhs);
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpression && !(parent instanceof PsiParenthesizedExpression) && ParenthesesUtils.getPrecedence((PsiExpression)parent) < 7) {
            expString = "(" + expString + ")";
        }
        return expString;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        PsiAssignmentExpression assignmentExpression;
        PsiBinaryExpression binaryExpression;
        IElementType operationTokenType;
        PsiExpression expression = (PsiExpression)infos[0];
        if (expression instanceof PsiBinaryExpression ? JavaTokenType.DIV.equals(operationTokenType = (binaryExpression = (PsiBinaryExpression)expression).getOperationTokenType()) : expression instanceof PsiAssignmentExpression && JavaTokenType.DIVEQ.equals(operationTokenType = (assignmentExpression = (PsiAssignmentExpression)expression).getOperationTokenType())) {
            return null;
        }
        return new MultiplyByPowerOfTwoFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantShiftVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/MultiplyOrDivideByPowerOfTwoInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MultiplyByPowerOfTwoFix
    extends PsiUpdateModCommandQuickFix {
        private MultiplyByPowerOfTwoFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("multiply.or.divide.by.power.of.two.replace.quickfix", new Object[0]);
            if (string == null) {
                MultiplyByPowerOfTwoFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            CommentTracker commentTracker;
            PsiExpression expression;
            String newExpression;
            if (project == null) {
                MultiplyByPowerOfTwoFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                MultiplyByPowerOfTwoFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MultiplyByPowerOfTwoFix.$$$reportNull$$$0(3);
            }
            if ((newExpression = MultiplyOrDivideByPowerOfTwoInspection.calculateReplacementShift(expression = (PsiExpression)startElement, commentTracker = new CommentTracker())) != null) {
                PsiReplacementUtil.replaceExpression(expression, newExpression, commentTracker);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/j2me/MultiplyOrDivideByPowerOfTwoInspection$MultiplyByPowerOfTwoFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/j2me/MultiplyOrDivideByPowerOfTwoInspection$MultiplyByPowerOfTwoFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ConstantShiftVisitor
    extends BaseInspectionVisitor {
        private ConstantShiftVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ConstantShiftVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.ASTERISK) || MultiplyOrDivideByPowerOfTwoInspection.this.checkDivision && tokenType.equals(JavaTokenType.DIV)) {
                this.process((PsiExpression)expression, rhs);
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                ConstantShiftVisitor.$$$reportNull$$$0(1);
            }
            super.visitAssignmentExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.ASTERISKEQ) || MultiplyOrDivideByPowerOfTwoInspection.this.checkDivision && tokenType.equals(JavaTokenType.DIVEQ)) {
                this.process((PsiExpression)expression, expression.getRExpression());
            }
        }

        private void process(PsiExpression anchor, PsiExpression rhs) {
            if (!ShiftUtils.isPowerOfTwo(rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs))) {
                return;
            }
            PsiType type = anchor.getType();
            if (type == null || !ClassUtils.isIntegral(type)) {
                return;
            }
            this.registerError((PsiElement)anchor, anchor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/j2me/MultiplyOrDivideByPowerOfTwoInspection$ConstantShiftVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

