/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class SuspiciousGetterSetterInspection
extends BaseInspection {
    public boolean onlyWarnWhenFieldPresent = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (Boolean)infos[0] != false ? InspectionGadgetsBundle.message("suspicious.setter.problem.descriptor", infos[1]) : InspectionGadgetsBundle.message("suspicious.getter.problem.descriptor", infos[1]);
        if (string == null) {
            SuspiciousGetterSetterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyWarnWhenFieldPresent", (String)JavaAnalysisBundle.message((String)"inspection.suspicious.getter.setter.field.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SuspiciousGetterSetterInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousGetterSetterVisitor();
    }

    private static boolean nameStartsWith(String name, String prefix) {
        return name.startsWith(prefix) && name.length() != prefix.length() && Character.isUpperCase(name.charAt(prefix.length()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javabeans/SuspiciousGetterSetterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SuspiciousGetterSetterVisitor
    extends BaseInspectionVisitor {
        private SuspiciousGetterSetterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            boolean setter;
            String extractedFieldName;
            String fieldName;
            if (method == null) {
                SuspiciousGetterSetterVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            String name = method.getName();
            if (SuspiciousGetterSetterInspection.nameStartsWith(name, "get")) {
                getterField = PropertyUtil.getFieldOfGetter(method);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name.substring(3);
                setter = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name, "is")) {
                getterField = PropertyUtil.getFieldOfGetter(method);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name.substring(2);
                setter = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name, "set")) {
                PsiField setterField = PropertyUtil.getFieldOfSetter(method);
                if (setterField == null) {
                    return;
                }
                fieldName = setterField.getName();
                extractedFieldName = name.substring(3);
                setter = true;
            } else {
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)method.getProject());
            String computedFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.FIELD);
            String computedStaticFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.STATIC_FINAL_FIELD);
            if (fieldName.equalsIgnoreCase(computedFieldName) || fieldName.equalsIgnoreCase(computedStaticFieldName)) {
                return;
            }
            if (SuspiciousGetterSetterInspection.this.onlyWarnWhenFieldPresent) {
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                if (aClass.findFieldByName(computedFieldName, true) == null && aClass.findFieldByName(computedStaticFieldName, true) == null) {
                    return;
                }
            }
            this.registerMethodError(method, setter, fieldName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/javabeans/SuspiciousGetterSetterInspection$SuspiciousGetterSetterVisitor", "visitMethod"));
        }
    }
}

