/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.modularization;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleWithTooFewClassesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    public boolean isGraphNeeded() {
        return false;
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            ModuleWithTooFewClassesInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            ModuleWithTooFewClassesInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            ModuleWithTooFewClassesInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            ModuleWithTooFewClassesInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefModule)) {
            return null;
        }
        RefModule refModule = (RefModule)refEntity;
        Project project = inspectionManager.getProject();
        if (ModuleManager.getInstance((Project)project).getModules().length == 1) {
            return null;
        }
        ModuleFileIndex index = ModuleRootManager.getInstance((Module)refModule.getModule()).getFileIndex();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        int[] count = new int[]{0};
        index.iterateContent(fileOrDir -> {
            if (fileOrDir.isDirectory()) {
                return true;
            }
            if (!analysisScope.contains(fileOrDir)) {
                return true;
            }
            PsiFile file = psiManager.findFile(fileOrDir);
            if (!(file instanceof PsiClassOwner)) {
                return true;
            }
            count[0] = count[0] + ((PsiClassOwner)file).getClasses().length;
            return count[0] <= this.limit;
        });
        if (count[0] >= this.limit || count[0] == 0) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("module.with.too.few.classes.problem.descriptor", refModule.getName(), count[0], this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"limit", (String)InspectionGadgetsBundle.message("module.with.too.few.classes.min.option", new Object[0]), (int)2, (int)1000)});
        if (optPane == null) {
            ModuleWithTooFewClassesInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/modularization/ModuleWithTooFewClassesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/modularization/ModuleWithTooFewClassesInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

