/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public final class BadOddnessInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.oddness.problem.descriptor", new Object[0]);
        if (string == null) {
            BadOddnessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BadOddnessVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/BadOddnessInspection", "buildErrorString"));
    }

    private static class BadOddnessVisitor
    extends BaseInspectionVisitor {
        private BadOddnessVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                BadOddnessVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
            PsiExpression rhs = expression.getROperand();
            if (BadOddnessVisitor.isModTwo(lhs) && BadOddnessVisitor.hasValue(rhs, 1)) {
                this.registerError((PsiElement)expression, expression);
            }
            if (BadOddnessVisitor.isModTwo(rhs) && BadOddnessVisitor.hasValue(lhs, 1)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isModTwo(PsiExpression exp) {
            if (!(exp instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binary = (PsiBinaryExpression)exp;
            IElementType tokenType = binary.getOperationTokenType();
            if (!JavaTokenType.PERC.equals(tokenType)) {
                return false;
            }
            PsiExpression rhs = binary.getROperand();
            PsiExpression lhs = binary.getLOperand();
            if (rhs == null) {
                return false;
            }
            return BadOddnessVisitor.hasValue(rhs, 2) && !BadOddnessVisitor.isChanged(lhs) && BadOddnessVisitor.canBeNegative(lhs);
        }

        private static boolean canBeNegative(PsiExpression lhs) {
            LongRangeSet range = CommonDataflow.getExpressionRange(lhs);
            return range == null || range.min() < 0L;
        }

        private static boolean isChanged(PsiExpression lhs) {
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)lhs).resolve(), PsiVariable.class);
            if (variable == null) {
                return false;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return false;
            }
            return !ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)codeBlock);
        }

        private static boolean hasValue(PsiExpression expression, int testValue) {
            Integer value = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiTypes.intType());
            return value != null && value == testValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/BadOddnessInspection$BadOddnessVisitor", "visitBinaryExpression"));
        }
    }
}

