/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryExplicitNumericCastInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final TokenSet binaryPromotionOperators = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.LT, JavaTokenType.LE, JavaTokenType.GT, JavaTokenType.GE, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.AND, JavaTokenType.XOR, JavaTokenType.OR});

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.problem.descriptor", expression.getText());
        if (string == null) {
            UnnecessaryExplicitNumericCastInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryExplicitNumericCastFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryExplicitNumericCastVisitor();
    }

    public static boolean isUnnecessaryPrimitiveNumericCast(PsiTypeCastExpression expression) {
        PsiType expectedType;
        PsiType castType = expression.getType();
        if (!ClassUtils.isPrimitiveNumericType(castType)) {
            return false;
        }
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            return false;
        }
        PsiType operandType = operand.getType();
        if (!ClassUtils.isPrimitiveNumericType(operandType)) {
            return false;
        }
        PsiElement parent = expression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (JavaTokenType.MINUS == tokenType || JavaTokenType.PLUS == tokenType || JavaTokenType.TILDE == tokenType) {
                if (TypeUtils.isNarrowingConversion(operandType, castType)) {
                    return false;
                }
                if (PsiTypes.intType().equals((Object)castType)) {
                    return !PsiTypes.longType().equals((Object)operandType) && !PsiTypes.floatType().equals((Object)operandType) && !PsiTypes.doubleType().equals((Object)operandType);
                }
            }
            return false;
        }
        if (castType.equals(operandType)) {
            return false;
        }
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (binaryPromotionOperators.contains(tokenType)) {
                if (TypeUtils.isNarrowingConversion(operandType, castType)) {
                    return false;
                }
                if (PsiTypes.intType().equals((Object)castType)) {
                    if (PsiTypes.charType().equals((Object)operandType) && TypeUtils.getStringType((PsiElement)polyadicExpression).equals((Object)polyadicExpression.getType())) {
                        return false;
                    }
                    return !PsiTypes.longType().equals((Object)operandType) && !PsiTypes.floatType().equals((Object)operandType) && !PsiTypes.doubleType().equals((Object)operandType);
                }
                if (PsiTypes.longType().equals((Object)castType) || PsiTypes.floatType().equals((Object)castType) || PsiTypes.doubleType().equals((Object)castType)) {
                    PsiExpression[] operands = polyadicExpression.getOperands();
                    int expressionIndex = -1;
                    for (int i = 0; i < operands.length; ++i) {
                        if (expressionIndex == 0 && i > 1) {
                            return false;
                        }
                        PsiExpression operand1 = operands[i];
                        if (PsiTreeUtil.isAncestor((PsiElement)operand1, (PsiElement)expression, (boolean)false)) {
                            if (i > 0) {
                                return false;
                            }
                            expressionIndex = i;
                            continue;
                        }
                        PsiType type = operand1.getType();
                        if (!castType.equals(type)) continue;
                        return true;
                    }
                }
            } else if (ElementType.SHIFT_OPS.contains(tokenType)) {
                PsiExpression firstOperand = polyadicExpression.getOperands()[0];
                if (!PsiTreeUtil.isAncestor((PsiElement)firstOperand, (PsiElement)expression, (boolean)false)) {
                    return true;
                }
                return !PsiTypes.longType().equals((Object)castType) && UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, (PsiType)PsiTypes.intType());
            }
            return false;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiType lhsType = assignmentExpression.getType();
            if (castType.equals(lhsType) && (UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand, lhsType) || UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, lhsType))) {
                return true;
            }
        } else if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null || typeElement.isInferredType()) {
                return false;
            }
            PsiType lhsType = variable.getType();
            if (castType.equals(lhsType) && (UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand, lhsType) || UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, lhsType))) {
                return true;
            }
        } else if (MethodCallUtils.isNecessaryForSurroundingMethodCall((PsiExpression)expression, operand)) {
            return false;
        }
        return operandType.equals(expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, false, true)) && UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand, castType) || castType.equals(expectedType) && UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, castType);
    }

    static boolean isLegalWideningConversion(PsiExpression expression, PsiType requiredType) {
        PsiType operandType = expression.getType();
        if (PsiTypes.doubleType().equals((Object)requiredType)) {
            return PsiTypes.floatType().equals((Object)operandType) || PsiTypes.longType().equals((Object)operandType) || PsiTypes.intType().equals((Object)operandType) || PsiTypes.charType().equals((Object)operandType) || PsiTypes.shortType().equals((Object)operandType) || PsiTypes.byteType().equals((Object)operandType);
        }
        if (PsiTypes.floatType().equals((Object)requiredType)) {
            return PsiTypes.longType().equals((Object)operandType) || PsiTypes.intType().equals((Object)operandType) || PsiTypes.charType().equals((Object)operandType) || PsiTypes.shortType().equals((Object)operandType) || PsiTypes.byteType().equals((Object)operandType);
        }
        if (PsiTypes.longType().equals((Object)requiredType)) {
            return PsiTypes.intType().equals((Object)operandType) || PsiTypes.charType().equals((Object)operandType) || PsiTypes.shortType().equals((Object)operandType) || PsiTypes.byteType().equals((Object)operandType);
        }
        if (PsiTypes.intType().equals((Object)requiredType)) {
            return PsiTypes.charType().equals((Object)operandType) || PsiTypes.shortType().equals((Object)operandType) || PsiTypes.byteType().equals((Object)operandType);
        }
        return false;
    }

    static boolean isLegalAssignmentConversion(PsiExpression expression, PsiType assignmentType) {
        if (PsiTypes.shortType().equals((Object)assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression, Short.MIN_VALUE, Short.MAX_VALUE);
        }
        if (PsiTypes.charType().equals((Object)assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression, 0, 65535);
        }
        if (PsiTypes.byteType().equals((Object)assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression, -128, 127);
        }
        return false;
    }

    private static boolean canValueBeContained(PsiExpression expression, int lowerBound, int upperBound) {
        PsiType expressionType = expression.getType();
        if (!PsiTypes.intType().equals((Object)expressionType)) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(expression);
        if (!(constant instanceof Integer)) {
            return false;
        }
        int i = (Integer)constant;
        return i >= lowerBound && i <= upperBound;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection", "buildErrorString"));
    }

    private static class UnnecessaryExplicitNumericCastFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryExplicitNumericCastFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryExplicitNumericCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                UnnecessaryExplicitNumericCastFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessaryExplicitNumericCastFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryExplicitNumericCastFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            if (!UnnecessaryExplicitNumericCastInspection.isUnnecessaryPrimitiveNumericCast(typeCastExpression)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            while (grandParent instanceof PsiParenthesizedExpression) {
                parent = grandParent;
                grandParent = parent.getParent();
            }
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                parent.delete();
            } else {
                parent.replace((PsiElement)operand);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection$UnnecessaryExplicitNumericCastFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection$UnnecessaryExplicitNumericCastFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessaryExplicitNumericCastVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryExplicitNumericCastVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                UnnecessaryExplicitNumericCastVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            if (!UnnecessaryExplicitNumericCastInspection.isUnnecessaryPrimitiveNumericCast(expression)) {
                return;
            }
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement != null) {
                this.registerError((PsiElement)typeElement, expression.getOperand());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection$UnnecessaryExplicitNumericCastVisitor", "visitTypeCastExpression"));
        }
    }
}

