/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.numeric.UnaryPlusInspection;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryUnaryMinusInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryUnaryMinusInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])infos[0];
        if (localQuickFixArray == null) {
            UnnecessaryUnaryMinusInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnaryMinusVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryUnaryMinusVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnaryMinusVisitor() {
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression prefixExpr) {
            if (prefixExpr == null) {
                UnnecessaryUnaryMinusVisitor.$$$reportNull$$$0(0);
            }
            super.visitPrefixExpression(prefixExpr);
            if (!UnaryPlusInspection.ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression(prefixExpr, false)) {
                return;
            }
            PsiExpression operand = prefixExpr.getOperand();
            if (operand == null) {
                return;
            }
            SmartList fixes = new SmartList();
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)UnnecessaryUnaryMinusVisitor.createReplaceParentOperatorFix(prefixExpr));
            if (this.isOnTheFly()) {
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)UnaryPlusInspection.ConvertDoubleUnaryToPrefixOperationFix.createFix(prefixExpr));
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)UnnecessaryUnaryMinusVisitor.createRemoveDoubleUnaryMinusFix(prefixExpr));
            }
            if (!fixes.isEmpty()) {
                this.registerError((PsiElement)prefixExpr.getOperationSign(), new Object[]{fixes.toArray(LocalQuickFix.EMPTY_ARRAY)});
            }
        }

        private static LocalQuickFix createReplaceParentOperatorFix(@NotNull PsiPrefixExpression prefixExpr) {
            PsiElement parent;
            if (prefixExpr == null) {
                UnnecessaryUnaryMinusVisitor.$$$reportNull$$$0(1);
            }
            if ((parent = prefixExpr.getParent()) instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                if (ExpressionUtils.hasType((PsiExpression)polyadicExpression, "java.lang.String")) {
                    return null;
                }
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand((PsiExpression)prefixExpr);
                if (token == null) {
                    return null;
                }
                IElementType tokenType = token.getTokenType();
                if (!JavaTokenType.PLUS.equals(tokenType) && !JavaTokenType.MINUS.equals(tokenType)) {
                    return null;
                }
                return new ReplaceParentOperatorFix();
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                if (ExpressionUtils.hasType((PsiExpression)assignmentExpression, "java.lang.String")) {
                    return null;
                }
                IElementType assignmentTokenType = assignmentExpression.getOperationTokenType();
                if (!JavaTokenType.PLUSEQ.equals(assignmentTokenType)) {
                    return null;
                }
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (!prefixExpr.equals((Object)rhs)) {
                    return null;
                }
                return new ReplaceParentOperatorFix();
            }
            return null;
        }

        private static LocalQuickFix createRemoveDoubleUnaryMinusFix(@NotNull PsiPrefixExpression prefixExpr) {
            boolean minusOnTheLeft;
            PsiExpression expr;
            PsiExpression operandExpr;
            if (prefixExpr == null) {
                UnnecessaryUnaryMinusVisitor.$$$reportNull$$$0(2);
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)prefixExpr.getParent());
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpr.getOperand());
            if (operand == null) {
                return null;
            }
            if (parent instanceof PsiPrefixExpression && UnaryPlusInspection.ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression((PsiPrefixExpression)parent, false)) {
                operandExpr = prefixExpr.getOperand();
                expr = (PsiExpression)parent;
                minusOnTheLeft = false;
            } else if (operand instanceof PsiPrefixExpression && UnaryPlusInspection.ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression((PsiPrefixExpression)operand, false)) {
                operandExpr = ((PsiPrefixExpression)operand).getOperand();
                expr = prefixExpr;
                minusOnTheLeft = true;
            } else {
                return null;
            }
            if (operandExpr == null) {
                return null;
            }
            PsiType type = operandExpr.getType();
            if (TypeUtils.unaryNumericPromotion(type) != type && MethodCallUtils.isNecessaryForSurroundingMethodCall(expr, operandExpr)) {
                return null;
            }
            return new RemoveDoubleUnaryMinusFix(minusOnTheLeft);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "prefixExpr";
            objectArray2[1] = "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection$UnnecessaryUnaryMinusVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createReplaceParentOperatorFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRemoveDoubleUnaryMinusFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RemoveDoubleUnaryMinusFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myMinusOnTheLeft;

        private RemoveDoubleUnaryMinusFix(boolean minusOnTheLeft) {
            this.myMinusOnTheLeft = minusOnTheLeft;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.remove.quickfix", new Object[0]);
            if (string == null) {
                RemoveDoubleUnaryMinusFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression operand;
            PsiPrefixExpression oldExpr;
            PsiPrefixExpression prefixExpr;
            if (project == null) {
                RemoveDoubleUnaryMinusFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                RemoveDoubleUnaryMinusFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveDoubleUnaryMinusFix.$$$reportNull$$$0(3);
            }
            if ((prefixExpr = (PsiPrefixExpression)ObjectUtils.tryCast((Object)startElement.getParent(), PsiPrefixExpression.class)) == null) {
                return;
            }
            if (this.myMinusOnTheLeft) {
                PsiPrefixExpression child = (PsiPrefixExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpr.getOperand()), PsiPrefixExpression.class);
                if (child == null) {
                    return;
                }
                oldExpr = prefixExpr;
                operand = child.getOperand();
            } else {
                PsiPrefixExpression parent = (PsiPrefixExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)prefixExpr.getParent()), PsiPrefixExpression.class);
                if (parent == null) {
                    return;
                }
                oldExpr = parent;
                operand = prefixExpr.getOperand();
            }
            if (operand == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)oldExpr, operand.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection$RemoveDoubleUnaryMinusFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection$RemoveDoubleUnaryMinusFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceParentOperatorFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceParentOperatorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.quickfix", new Object[0]);
            if (string == null) {
                ReplaceParentOperatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiPrefixExpression prefixExpression;
            PsiExpression operand;
            if (project == null) {
                ReplaceParentOperatorFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceParentOperatorFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceParentOperatorFix.$$$reportNull$$$0(3);
            }
            if ((operand = (prefixExpression = (PsiPrefixExpression)element.getParent()).getOperand()) == null) {
                return;
            }
            PsiExpression parentExpression = (PsiExpression)prefixExpression.getParent();
            CommentTracker commentTracker = new CommentTracker();
            @NonNls StringBuilder newExpression = new StringBuilder();
            if (parentExpression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parentExpression;
                PsiExpression lhs = assignmentExpression.getLExpression();
                newExpression.append(commentTracker.text((PsiElement)lhs));
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType.equals(JavaTokenType.PLUSEQ)) {
                    newExpression.append("-=");
                } else {
                    newExpression.append("+=");
                }
                newExpression.append(commentTracker.text((PsiElement)operand));
            } else if (parentExpression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parentExpression;
                int lastOperatorIndex = -1;
                IElementType lastOperator = null;
                for (PsiElement child = polyadicExpression.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child == prefixExpression) {
                        if (lastOperatorIndex == -1) {
                            return;
                        }
                        newExpression.replace(lastOperatorIndex, lastOperatorIndex + 1, lastOperator == JavaTokenType.PLUS ? "-" : "+");
                        newExpression.append(commentTracker.text((PsiElement)operand));
                        continue;
                    }
                    if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.PLUS)) {
                        lastOperatorIndex = newExpression.length();
                        lastOperator = JavaTokenType.PLUS;
                    } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.MINUS)) {
                        lastOperatorIndex = newExpression.length();
                        lastOperator = JavaTokenType.MINUS;
                    }
                    newExpression.append(commentTracker.text(child));
                }
                if (lastOperatorIndex == -1) {
                    return;
                }
            }
            PsiReplacementUtil.replaceExpression(parentExpression, newExpression.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection$ReplaceParentOperatorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection$ReplaceParentOperatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

