/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PackageGlobalInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageWithTooFewClassesInspection
extends PackageGlobalInspection {
    public int limit = 3;

    @Override
    public CommonProblemDescriptor @Nullable [] checkPackage(@NotNull RefPackage refPackage, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        int numClasses;
        if (refPackage == null) {
            PackageWithTooFewClassesInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            PackageWithTooFewClassesInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            PackageWithTooFewClassesInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            PackageWithTooFewClassesInspection.$$$reportNull$$$0(3);
        }
        if ((numClasses = ((Integer)ReadAction.compute(() -> {
            Project project = inspectionManager.getProject();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(refPackage.getQualifiedName());
            if (aPackage == null || aPackage.getSubPackages().length > 0) {
                return -1;
            }
            return aPackage.getClasses(GlobalSearchScope.projectScope((Project)project)).length;
        })).intValue()) < 0 || numClasses >= this.limit) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.with.too.few.classes.problem.descriptor", refPackage.getQualifiedName(), numClasses, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"limit", (String)InspectionGadgetsBundle.message("package.with.too.few.classes.min.option", new Object[0]), (int)1, (int)1000)});
        if (optPane == null) {
            PackageWithTooFewClassesInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/packaging/PackageWithTooFewClassesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/packaging/PackageWithTooFewClassesInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkPackage";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

