/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class LengthOneStringsInConcatenationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "SingleCharacterStringConcatenation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        String escapedString = StringUtil.escapeStringCharacters((String)string);
        String string2 = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", escapedString);
        if (string2 == null) {
            LengthOneStringsInConcatenationInspection.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceStringsWithCharsFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LengthOneStringsInConcatenationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection", "buildErrorString"));
    }

    private static class ReplaceStringsWithCharsFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceStringsWithCharsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("length.one.strings.in.concatenation.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            String s;
            PsiLiteralExpression expression;
            if (project == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(3);
            }
            if (ExpressionUtils.isConversionToStringNecessary((PsiExpression)(expression = (PsiLiteralExpression)startElement), false)) {
                return;
            }
            Object object = expression.getValue();
            if (!(object instanceof String) || (s = (String)object).length() != 1) {
                return;
            }
            String charLiteral = PsiLiteralUtil.charLiteralString((PsiLiteralExpression)expression);
            if (charLiteral == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, charLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection$ReplaceStringsWithCharsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection$ReplaceStringsWithCharsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class LengthOneStringsInConcatenationVisitor
    extends BaseInspectionVisitor {
        private LengthOneStringsInConcatenationVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                LengthOneStringsInConcatenationVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            String value = (String)expression.getValue();
            if (value == null || value.length() != 1) {
                return;
            }
            if (ExpressionUtils.isConversionToStringNecessary((PsiExpression)expression, false)) {
                return;
            }
            this.registerError((PsiElement)expression, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection$LengthOneStringsInConcatenationVisitor", "visitLiteralExpression"));
        }
    }
}

