/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class TrivialStringConcatenationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean skipIfNecessary = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"skipIfNecessary", (String)InspectionGadgetsBundle.message("trivial.string.concatenation.option.only.necessary", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            TrivialStringConcatenationInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public String getID() {
        return "ConcatenationWithEmptyString";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.string.concatenation.problem.descriptor", new Object[0]);
        if (string == null) {
            TrivialStringConcatenationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void fixBinaryExpression(PsiPolyadicExpression expression) {
        CommentTracker commentTracker = new CommentTracker();
        PsiExpression[] operands = expression.getOperands();
        PsiExpression lOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[0]);
        PsiExpression rOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[1]);
        PsiExpression replacement = ExpressionUtils.isEmptyStringLiteral(lOperand) ? rOperand : lOperand;
        String newText = replacement == null ? "" : TrivialStringConcatenationInspection.buildReplacement(replacement, false, commentTracker);
        PsiReplacementUtil.replaceExpression((PsiExpression)expression, newText, commentTracker);
    }

    private static void fixLastExpression(final PsiPolyadicExpression polyadicExpression, boolean seenStringBefore) {
        PsiExpression[] operands = polyadicExpression.getOperands();
        PsiExpression beforeLast = operands[operands.length - 2];
        StringBuilder builder = new StringBuilder();
        boolean meetBeforeLast = false;
        boolean afterPlus = false;
        final CommentTracker generalCommentTracker = new CommentTracker();
        CommentTracker beforeLastCommentTracker = new CommentTracker();
        for (PsiElement child : polyadicExpression.getChildren()) {
            PsiJavaToken token;
            if (!meetBeforeLast) {
                if (beforeLast == child) {
                    meetBeforeLast = true;
                }
                builder.append(child.getText());
                generalCommentTracker.markUnchanged(child);
                continue;
            }
            if (child instanceof PsiJavaToken && (token = (PsiJavaToken)child).getTokenType() == JavaTokenType.PLUS) {
                afterPlus = true;
            }
            if (afterPlus) continue;
            beforeLastCommentTracker.grabComments(child);
            generalCommentTracker.markUnchanged(child);
        }
        Object text = builder.toString().trim();
        if (!seenStringBefore) {
            text = "String.valueOf(" + (String)text + ")";
        }
        final String finalText = text;
        PsiElement replacementExpression = (PsiElement)CodeStyleManager.getInstance((Project)polyadicExpression.getProject()).performActionWithFormatterDisabled((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                return generalCommentTracker.replaceAndRestoreComments((PsiElement)polyadicExpression, finalText);
            }
        });
        if (replacementExpression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression psiPolyadicExpression = (PsiPolyadicExpression)replacementExpression;
            PsiExpression[] expressionOperands = psiPolyadicExpression.getOperands();
            if (expressionOperands.length == 0) {
                return;
            }
            PsiExpression lastOperand = expressionOperands[expressionOperands.length - 1];
            beforeLastCommentTracker.insertCommentsBefore((PsiElement)lastOperand);
        }
    }

    private static void fixExpressionInMiddle(PsiExpression expression, final PsiPolyadicExpression polyadicExpression, boolean seenString) {
        boolean isFirstOperand;
        PsiJavaToken javaToken;
        PsiElement nextPlus;
        PsiJavaToken javaToken2;
        PsiElement previousPlus;
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
        if (parent == null) {
            return;
        }
        for (previousPlus = expression.getPrevSibling(); !(previousPlus == null || previousPlus instanceof PsiJavaToken && (javaToken2 = (PsiJavaToken)previousPlus).getTokenType() == JavaTokenType.PLUS); previousPlus = previousPlus.getPrevSibling()) {
        }
        for (nextPlus = expression.getNextSibling(); !(nextPlus == null || nextPlus instanceof PsiJavaToken && (javaToken = (PsiJavaToken)nextPlus).getTokenType() == JavaTokenType.PLUS); nextPlus = nextPlus.getNextSibling()) {
        }
        if (nextPlus == null) {
            return;
        }
        int position = 0;
        PsiExpression[] operands = polyadicExpression.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            if (operands[i] != expression) continue;
            position = i;
        }
        if (position >= operands.length - 1) {
            return;
        }
        PsiExpression nextExpression = operands[position + 1];
        final StringBuilder builder = new StringBuilder();
        boolean meetPreviousPlus = isFirstOperand = operands[0] == expression;
        boolean meetNextPlus = false;
        boolean meetNextOperand = false;
        final CommentTracker generalTracker = new CommentTracker();
        CommentTracker firstTracker = new CommentTracker();
        for (PsiElement child : polyadicExpression.getChildren()) {
            if (!meetPreviousPlus) {
                if (previousPlus != child) {
                    builder.append(child.getText());
                    generalTracker.markUnchanged(child);
                    continue;
                }
                meetPreviousPlus = true;
                builder.append(child.getText());
                continue;
            }
            if (!meetNextPlus) {
                if (nextPlus != child) continue;
                meetNextPlus = true;
                continue;
            }
            if (!meetNextOperand) {
                if (nextExpression != child) {
                    if (isFirstOperand) {
                        firstTracker.grabComments(child);
                        generalTracker.markUnchanged(child);
                        continue;
                    }
                    builder.append(child.getText());
                    generalTracker.markUnchanged(child);
                    continue;
                }
                builder.append(TrivialStringConcatenationInspection.buildReplacement(nextExpression, seenString, generalTracker));
                meetNextOperand = true;
                continue;
            }
            builder.append(child.getText());
            generalTracker.markUnchanged(child);
        }
        PsiElement replacementExpression = (PsiElement)CodeStyleManager.getInstance((Project)polyadicExpression.getProject()).performActionWithFormatterDisabled((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                return generalTracker.replaceAndRestoreComments((PsiElement)polyadicExpression, builder.toString().trim());
            }
        });
        if (replacementExpression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression psiPolyadicExpression = (PsiPolyadicExpression)replacementExpression;
            PsiExpression[] expressionOperands = psiPolyadicExpression.getOperands();
            if (expressionOperands.length - 1 < position) {
                return;
            }
            firstTracker.insertCommentsBefore(replacementExpression);
        }
    }

    @NonNls
    static String buildReplacement(@NotNull PsiExpression operandToReplace, boolean seenString, CommentTracker commentTracker) {
        if (operandToReplace == null) {
            TrivialStringConcatenationInspection.$$$reportNull$$$0(2);
        }
        if (ExpressionUtils.isNullLiteral(operandToReplace)) {
            if (seenString) {
                return "null";
            }
            return "String.valueOf((Object) null)";
        }
        if (seenString || ExpressionUtils.hasStringType(operandToReplace)) {
            return operandToReplace.getText();
        }
        PsiExpression skipDown = PsiUtil.skipParenthesizedExprDown((PsiExpression)operandToReplace);
        operandToReplace = skipDown == null ? operandToReplace : skipDown;
        return "String.valueOf(" + commentTracker.text((PsiElement)operandToReplace) + ")";
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryTemporaryObjectFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialStringConcatenationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/TrivialStringConcatenationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandToReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/TrivialStringConcatenationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class UnnecessaryTemporaryObjectFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String m_name = InspectionGadgetsBundle.message("string.replace.quickfix", new Object[0]);

        UnnecessaryTemporaryObjectFix() {
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.temporary.object.fix.family.name", new Object[0]);
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiType type2;
            if (project == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(4);
            }
            PsiElement current = startElement;
            while (current.getParent() instanceof PsiParenthesizedExpression) {
                current = current.getParent();
            }
            if (!(current instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)current;
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            PsiType polyadicExpressionType = polyadicExpression.getType();
            if (polyadicExpressionType == null || !polyadicExpressionType.equalsToText("java.lang.String")) {
                return;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length == 1) {
                return;
            }
            if (operands.length == 2) {
                TrivialStringConcatenationInspection.fixBinaryExpression(polyadicExpression);
                return;
            }
            boolean seenString = Stream.of(operands).takeWhile(t -> t != expression).anyMatch(t -> t.getType() != null && t.getType().equalsToText("java.lang.String"));
            if (operands[0] == expression && (type2 = operands[2].getType()) != null && type2.equalsToText("java.lang.String")) {
                seenString = true;
            }
            if (operands[operands.length - 1] == expression) {
                TrivialStringConcatenationInspection.fixLastExpression(polyadicExpression, seenString);
            } else {
                TrivialStringConcatenationInspection.fixExpressionInMiddle(expression, polyadicExpression, seenString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/TrivialStringConcatenationInspection$UnnecessaryTemporaryObjectFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/TrivialStringConcatenationInspection$UnnecessaryTemporaryObjectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class TrivialStringConcatenationVisitor
    extends BaseInspectionVisitor {
        private TrivialStringConcatenationVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                TrivialStringConcatenationVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            if (!ExpressionUtils.hasStringType((PsiExpression)expression)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            boolean constant = PsiUtil.isConstantExpression((PsiExpression)expression);
            boolean seenString = false;
            for (int i = 0; i < operands.length; ++i) {
                PsiExpression nextNext;
                PsiExpression next;
                PsiExpression previous;
                PsiExpression operand = operands[i];
                if ((operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand)) == null) {
                    return;
                }
                if (i > 0 && !seenString && ExpressionUtils.hasStringType(previous = operands[i - 1])) {
                    seenString = true;
                }
                if (!ExpressionUtils.isEmptyStringLiteral(operand) || (TrivialStringConcatenationInspection.this.skipIfNecessary || constant) && !seenString && (i == operands.length - 1 || !ExpressionUtils.hasStringType(next = operands[i + 1]) && (operands.length == 2 || i != 0 || !ExpressionUtils.hasStringType(nextNext = operands[i + 2]) || ExpressionUtils.isEmptyStringLiteral(nextNext)))) continue;
                this.registerError((PsiElement)operand, operand);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/TrivialStringConcatenationInspection$TrivialStringConcatenationVisitor", "visitPolyadicExpression"));
        }
    }
}

