/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InitializationUtils {
    private InitializationUtils() {
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable) {
        if (variable == null) {
            InitializationUtils.$$$reportNull$$$0(0);
        }
        return InitializationUtils.methodAssignsVariableOrFails(method, variable, false);
    }

    public static boolean expressionAssignsVariableOrFails(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            InitializationUtils.$$$reportNull$$$0(1);
        }
        return InitializationUtils.expressionAssignsVariableOrFails(expression, variable, new HashSet<MethodSignature>(), true);
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable, boolean strict) {
        if (variable == null) {
            InitializationUtils.$$$reportNull$$$0(2);
        }
        if (method == null) {
            return false;
        }
        return InitializationUtils.blockAssignsVariableOrFails(method.getBody(), variable, strict);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (variable == null) {
            InitializationUtils.$$$reportNull$$$0(3);
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable, false);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, boolean strict) {
        if (variable == null) {
            InitializationUtils.$$$reportNull$$$0(4);
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable, new HashSet<MethodSignature>(), strict);
    }

    private static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (variable == null) {
            InitializationUtils.$$$reportNull$$$0(5);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(6);
        }
        if (block == null) {
            return false;
        }
        int assignmentCount = 0;
        for (PsiStatement statement : block.getStatements()) {
            if (!InitializationUtils.statementAssignsVariableOrFails(statement, variable, checkedMethods, strict)) continue;
            if (strict) {
                ++assignmentCount;
                continue;
            }
            return true;
        }
        return assignmentCount == 1;
    }

    private static boolean statementAssignsVariableOrFails(@Nullable PsiStatement statement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(7);
        }
        if (statement == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement)) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiAssertStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            return InitializationUtils.expressionAssignsVariableOrFails(returnStatement.getReturnValue(), variable, checkedMethods, strict);
        }
        if (statement instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
            return InitializationUtils.expressionAssignsVariableOrFails(throwStatement.getException(), variable, checkedMethods, strict);
        }
        if (statement instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement list = (PsiExpressionListStatement)statement;
            PsiExpressionList expressionList = list.getExpressionList();
            for (PsiExpression expression : expressionList.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(expression, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            return InitializationUtils.expressionAssignsVariableOrFails(expressionStatement.getExpression(), variable, checkedMethods, strict);
        }
        if (statement instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            return InitializationUtils.declarationStatementAssignsVariableOrFails(declarationStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement;
            return InitializationUtils.forStatementAssignsVariableOrFails(forStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement;
            return InitializationUtils.foreachStatementAssignsVariableOrFails(foreachStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
            return InitializationUtils.whileStatementAssignsVariableOrFails(whileStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
            return InitializationUtils.doWhileAssignsVariableOrFails(doWhileStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            return InitializationUtils.blockAssignsVariableOrFails(synchronizedStatement.getBody(), variable, checkedMethods, strict);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            return InitializationUtils.blockAssignsVariableOrFails(blockStatement.getCodeBlock(), variable, checkedMethods, strict);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            return InitializationUtils.statementAssignsVariableOrFails(labeledStatement.getStatement(), variable, checkedMethods, strict);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            return InitializationUtils.ifStatementAssignsVariableOrFails(ifStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            return InitializationUtils.tryStatementAssignsVariableOrFails(tryStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
            return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, variable, checkedMethods, strict);
        }
        return false;
    }

    private static boolean switchStatementAssignsVariableOrFails(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpression expression;
        if (switchStatement == null) {
            InitializationUtils.$$$reportNull$$$0(8);
        }
        if (variable == null) {
            InitializationUtils.$$$reportNull$$$0(9);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(10);
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(expression = switchStatement.getExpression(), variable, checkedMethods, strict)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i = 0; i < statements.length; ++i) {
            PsiStatement statement = statements[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement;
                if (i == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
                if (breakStatement.getLabelIdentifier() != null) {
                    return false;
                }
                if (!assigns) {
                    return false;
                }
                assigns = false;
                continue;
            }
            if (i != statements.length - 1 || (assigns |= InitializationUtils.statementAssignsVariableOrFails(statement, variable, checkedMethods, strict))) continue;
            return false;
        }
        return containsDefault;
    }

    private static boolean declarationStatementAssignsVariableOrFails(PsiDeclarationStatement declarationStatement, PsiVariable variable, Set<MethodSignature> checkedMethods, boolean strict) {
        PsiElement[] elements;
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable declaredVariable;
            if (!(element instanceof PsiVariable) || !InitializationUtils.expressionAssignsVariableOrFails((declaredVariable = (PsiVariable)element).getInitializer(), variable, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementAssignsVariableOrFails(@NotNull PsiTryStatement tryStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiCodeBlock[] catchBlocks;
        PsiResourceList resourceList;
        if (tryStatement == null) {
            InitializationUtils.$$$reportNull$$$0(11);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(12);
        }
        if ((resourceList = tryStatement.getResourceList()) != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiExpression initializer;
                if (!(resource instanceof PsiResourceVariable) || !InitializationUtils.expressionAssignsVariableOrFails(initializer = ((PsiResourceVariable)resource).getInitializer(), variable, checkedMethods, strict)) continue;
                return true;
            }
        }
        boolean initializedInTryAndCatch = InitializationUtils.blockAssignsVariableOrFails(tryStatement.getTryBlock(), variable, checkedMethods, strict);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (strict) {
                initializedInTryAndCatch &= ExceptionUtils.blockThrowsException(catchBlock);
                continue;
            }
            initializedInTryAndCatch &= InitializationUtils.blockAssignsVariableOrFails(catchBlock, variable, checkedMethods, false);
        }
        return initializedInTryAndCatch || InitializationUtils.blockAssignsVariableOrFails(tryStatement.getFinallyBlock(), variable, checkedMethods, strict);
    }

    private static boolean ifStatementAssignsVariableOrFails(@NotNull PsiIfStatement ifStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpression condition;
        if (ifStatement == null) {
            InitializationUtils.$$$reportNull$$$0(13);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(14);
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(condition = ifStatement.getCondition(), variable, checkedMethods, strict)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (BoolUtils.isTrue(condition)) {
            return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable, checkedMethods, strict);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (BoolUtils.isFalse(condition)) {
            return InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable, checkedMethods, strict);
        }
        return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable, checkedMethods, strict) && InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable, checkedMethods, strict);
    }

    private static boolean doWhileAssignsVariableOrFails(@NotNull PsiDoWhileStatement doWhileStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (doWhileStatement == null) {
            InitializationUtils.$$$reportNull$$$0(15);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(16);
        }
        return InitializationUtils.statementAssignsVariableOrFails(doWhileStatement.getBody(), variable, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(doWhileStatement.getCondition(), variable, checkedMethods, strict);
    }

    private static boolean whileStatementAssignsVariableOrFails(@NotNull PsiWhileStatement whileStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpression condition;
        if (whileStatement == null) {
            InitializationUtils.$$$reportNull$$$0(17);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(18);
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(condition = whileStatement.getCondition(), variable, checkedMethods, strict)) {
            return true;
        }
        if (BoolUtils.isTrue(condition)) {
            PsiStatement body = whileStatement.getBody();
            return InitializationUtils.statementAssignsVariableOrFails(body, variable, checkedMethods, strict);
        }
        return false;
    }

    private static boolean forStatementAssignsVariableOrFails(@NotNull PsiForStatement forStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (forStatement == null) {
            InitializationUtils.$$$reportNull$$$0(19);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(20);
        }
        if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getInitialization(), variable, checkedMethods, strict)) {
            return true;
        }
        PsiExpression condition = forStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(condition, variable, checkedMethods, strict)) {
            return true;
        }
        if (BoolUtils.isTrue(condition)) {
            if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getBody(), variable, checkedMethods, strict)) {
                return true;
            }
            return InitializationUtils.statementAssignsVariableOrFails(forStatement.getUpdate(), variable, checkedMethods, strict);
        }
        return false;
    }

    private static boolean foreachStatementAssignsVariableOrFails(@NotNull PsiForeachStatement foreachStatement, PsiVariable field, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (foreachStatement == null) {
            InitializationUtils.$$$reportNull$$$0(21);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(22);
        }
        return InitializationUtils.expressionAssignsVariableOrFails(foreachStatement.getIteratedValue(), field, checkedMethods, strict);
    }

    private static boolean expressionAssignsVariableOrFails(@Nullable PsiExpression expression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(23);
        }
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression || expression instanceof PsiReferenceExpression) {
            return false;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            return InitializationUtils.expressionAssignsVariableOrFails(parenthesizedExpression.getExpression(), variable, checkedMethods, strict);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            return InitializationUtils.methodCallAssignsVariableOrFails(methodCallExpression, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            return InitializationUtils.newExpressionAssignsVariableOrFails(newExpression, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression;
            for (PsiExpression initializer : array.getInitializers()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(initializer, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression;
            return InitializationUtils.expressionAssignsVariableOrFails(typeCast.getOperand(), variable, checkedMethods, strict);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression;
            return InitializationUtils.expressionAssignsVariableOrFails(accessExpression.getArrayExpression(), variable, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(accessExpression.getIndexExpression(), variable, checkedMethods, strict);
        }
        if (expression instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryOperation = (PsiUnaryExpression)expression;
            return InitializationUtils.expressionAssignsVariableOrFails(unaryOperation.getOperand(), variable, checkedMethods, strict);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(operand, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            if (InitializationUtils.expressionAssignsVariableOrFails(conditional.getCondition(), variable, checkedMethods, strict)) {
                return true;
            }
            return InitializationUtils.expressionAssignsVariableOrFails(conditional.getThenExpression(), variable, checkedMethods, strict) && InitializationUtils.expressionAssignsVariableOrFails(conditional.getElseExpression(), variable, checkedMethods, strict);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            PsiExpression lhs = assignment.getLExpression();
            if (InitializationUtils.expressionAssignsVariableOrFails(lhs, variable, checkedMethods, strict)) {
                return true;
            }
            if (InitializationUtils.expressionAssignsVariableOrFails(assignment.getRExpression(), variable, checkedMethods, strict)) {
                return true;
            }
            if (lhs instanceof PsiReferenceExpression) {
                PsiElement element = ((PsiReference)lhs).resolve();
                return variable.equals((Object)element);
            }
            return false;
        }
        if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
            return InitializationUtils.expressionAssignsVariableOrFails(instanceOfExpression.getOperand(), variable, checkedMethods, strict);
        }
        return false;
    }

    private static boolean newExpressionAssignsVariableOrFails(@NotNull PsiNewExpression newExpression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpressionList argumentList;
        if (newExpression == null) {
            InitializationUtils.$$$reportNull$$$0(24);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(25);
        }
        if ((argumentList = newExpression.getArgumentList()) != null) {
            for (PsiExpression argument : argumentList.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(argument, variable, checkedMethods, strict)) continue;
                return true;
            }
        }
        if (InitializationUtils.expressionAssignsVariableOrFails((PsiExpression)newExpression.getArrayInitializer(), variable, checkedMethods, strict)) {
            return true;
        }
        for (PsiExpression dimension : newExpression.getArrayDimensions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(dimension, variable, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean methodCallAssignsVariableOrFails(@NotNull PsiMethodCallExpression callExpression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (callExpression == null) {
            InitializationUtils.$$$reportNull$$$0(26);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(27);
        }
        PsiExpressionList argumentList = callExpression.getArgumentList();
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(argument, variable, checkedMethods, strict)) continue;
            return true;
        }
        if (InitializationUtils.expressionAssignsVariableOrFails((PsiExpression)callExpression.getMethodExpression(), variable, checkedMethods, strict)) {
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals((Object)containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.hasModifierProperty("private") || method.hasModifierProperty("final") || method.isConstructor() || calledClass.hasModifierProperty("final")) {
            return InitializationUtils.blockAssignsVariableOrFails(method.getBody(), variable, checkedMethods, strict);
        }
        return false;
    }

    public static boolean isInitializedInConstructors(PsiField field, PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            if (InitializationUtils.methodAssignsVariableOrFails(constructor, (PsiVariable)field)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInitializedInInitializer(@NotNull PsiField field, @NotNull PsiClass aClass) {
        PsiClassInitializer[] initializers;
        if (field == null) {
            InitializationUtils.$$$reportNull$$$0(28);
        }
        if (aClass == null) {
            InitializationUtils.$$$reportNull$$$0(29);
        }
        for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
            PsiCodeBlock body;
            if (initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), (PsiVariable)field)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMethods";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doWhileStatement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreachStatement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/InitializationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "methodAssignsVariableOrFails";
                break;
            }
            case 1: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionAssignsVariableOrFails";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "blockAssignsVariableOrFails";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "statementAssignsVariableOrFails";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStatementAssignsVariableOrFails";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "tryStatementAssignsVariableOrFails";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "ifStatementAssignsVariableOrFails";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhileAssignsVariableOrFails";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "whileStatementAssignsVariableOrFails";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "forStatementAssignsVariableOrFails";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "foreachStatementAssignsVariableOrFails";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "newExpressionAssignsVariableOrFails";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "methodCallAssignsVariableOrFails";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "isInitializedInInitializer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

