/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.codeserver.core.JavaPsiAnnotationUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastUtils;

public final class MethodUtils {
    private static final Set<String> CAN_IGNORE_RETURN_VALUE_ANNOTATIONS = Set.of("org.assertj.core.util.CanIgnoreReturnValue", "org.assertj.core.annotation.CanIgnoreReturnValue", "com.google.errorprone.annotations.CanIgnoreReturnValue");

    private MethodUtils() {
    }

    public static boolean isInsideMethodBody(@NotNull PsiElement element, @Nullable PsiMethod method) {
        if (element == null) {
            MethodUtils.$$$reportNull$$$0(0);
        }
        return method != null && PsiTreeUtil.isAncestor((PsiElement)method.getBody(), (PsiElement)element, (boolean)true);
    }

    public static boolean isCopyConstructor(@Nullable PsiMethod constructor) {
        if (constructor == null || !constructor.isConstructor()) {
            return false;
        }
        PsiParameter[] parameters = constructor.getParameterList().getParameters();
        return parameters.length == 1 && constructor.getContainingClass() == PsiUtil.resolveClassInClassTypeOnly((PsiType)parameters[0].getType());
    }

    @Contract(value="null -> false")
    public static boolean isComparatorCompare(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, "java.util.Comparator", (PsiType)PsiTypes.intType(), "compare", null, null);
    }

    @Contract(value="null -> false")
    public static boolean isCompareTo(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.intType(), "compareTo", PsiTypes.nullType()) && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.lang.Comparable");
    }

    @Contract(value="null -> false")
    public static boolean isCompareToIgnoreCase(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, "java.lang.String", (PsiType)PsiTypes.intType(), "compareToIgnoreCase", new PsiType[]{stringType});
    }

    @Contract(value="null -> false")
    public static boolean isHashCode(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.intType(), "hashCode", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isFinalize(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.voidType(), "finalize", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isToString(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)stringType, "toString", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isEquals(@Nullable PsiMethod method) {
        if (method == null || !"equals".equals(method.getName())) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() == 1 && PsiTypes.booleanType().equals((Object)method.getReturnType()) && TypeUtils.isJavaLangObject(Objects.requireNonNull(parameterList.getParameter(0)).getType());
    }

    @Contract(value="null -> false")
    public static boolean isEqualsIgnoreCase(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, "java.lang.String", (PsiType)PsiTypes.booleanType(), "equalsIgnoreCase", new PsiType[]{stringType});
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        String name;
        Matcher matcher;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(1);
        }
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(name = method.getName())).matches()) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(2);
        }
        String name = method.getName();
        if (methodName != null && !methodName.equals(name)) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    private static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, PsiType ... parameterTypes) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(3);
        }
        if (parameterTypes != null) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.length) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                ProgressManager.checkCanceled();
                PsiParameter parameter = parameters[i];
                PsiType type = parameter.getType();
                PsiType parameterType = parameterTypes[i];
                if (PsiTypes.nullType().equals(parameterType) || parameterType == null || EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(type, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null) {
            PsiType methodReturnType = method.getReturnType();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(returnType, methodReturnType)) {
                return false;
            }
        }
        if (containingClassName != null) {
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)containingClassName);
        }
        return true;
    }

    public static boolean simpleMethodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @NonNls @Nullable String returnTypeString, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(4);
        }
        Project project = method.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        try {
            if (parameterTypeStrings != null) {
                PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
                for (int i = 0; i < parameterTypeStrings.length; ++i) {
                    ProgressManager.checkCanceled();
                    String parameterTypeString = parameterTypeStrings[i];
                    parameterTypes[i] = factory.createTypeFromText(parameterTypeString, (PsiElement)method);
                }
                if (returnTypeString != null) {
                    PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                    return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, parameterTypes);
                }
                return MethodUtils.methodMatches(method, containingClassName, null, methodName, parameterTypes);
            }
            if (returnTypeString != null) {
                PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, new PsiType[0]);
            }
            return MethodUtils.methodMatches(method, containingClassName, null, methodName, new PsiType[0]);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasSuper(@NotNull PsiMethod method) {
        PsiAnnotation overrideAnnotation;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(5);
        }
        return (overrideAnnotation = method.getModifierList().findAnnotation("java.lang.Override")) != null || MethodUtils.getSuper(method) != null;
    }

    @Nullable
    public static PsiMethod getSuper(@NotNull PsiMethod method) {
        MethodSignatureBackedByPsiMethod signature;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(6);
        }
        if ((signature = MethodUtils.getSuperMethodSignature(method)) == null) {
            return null;
        }
        return signature.getMethod();
    }

    @Nullable
    public static MethodSignatureBackedByPsiMethod getSuperMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(7);
        }
        if (method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
            return null;
        }
        return (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
    }

    public static boolean isOverridden(@NotNull PsiMethod method) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(8);
        }
        return OverridingMethodsSearch.search((PsiMethod)method, (boolean)false).findFirst() != null;
    }

    public static boolean isOverriddenInHierarchy(@NotNull PsiMethod method, @NotNull PsiClass baseClass) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(9);
        }
        if (baseClass == null) {
            MethodUtils.$$$reportNull$$$0(10);
        }
        if (!PsiUtil.canBeOverridden((PsiMethod)method) || baseClass instanceof PsiAnonymousClass || baseClass.hasModifierProperty("final")) {
            return false;
        }
        Query search = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)baseClass.getUseScope(), (boolean)true, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search.asIterable()) {
            PsiMethod overridingMethod = inheritor.findMethodBySignature(method, false);
            if (overridingMethod == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(PsiMethod method) {
        return ControlFlowUtils.isEmptyCodeBlock(method.getBody());
    }

    public static boolean isTrivial(PsiMethod method, @Nullable Predicate<? super PsiStatement> considerTrivialPredicate) {
        if (method.hasModifierProperty("native")) {
            return false;
        }
        return MethodUtils.isTrivial(method.getBody(), considerTrivialPredicate);
    }

    public static boolean isTrivial(PsiMethod method) {
        return MethodUtils.isTrivial(method, null);
    }

    public static boolean isTrivial(PsiClassInitializer initializer) {
        return MethodUtils.isTrivial(initializer.getBody(), null);
    }

    private static boolean isTrivial(PsiCodeBlock codeBlock, @Nullable Predicate<? super PsiStatement> trivialPredicate) {
        PsiStatement[] statements;
        if (codeBlock == null) {
            return true;
        }
        for (PsiStatement statement : statements = codeBlock.getStatements()) {
            ProgressManager.checkCanceled();
            if (statement instanceof PsiEmptyStatement || trivialPredicate != null && trivialPredicate.test((PsiStatement)statement)) continue;
            if (statement instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                PsiExpression returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue());
                if (returnValue == null || returnValue instanceof PsiLiteralExpression) continue;
                return false;
            }
            if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition = ifStatement.getCondition();
                Object result = ExpressionUtils.computeConstantExpression(condition);
                if (result != null && result.equals(Boolean.FALSE)) continue;
                return false;
            }
            if (statement instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
                if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)expressionStatement.getExpression())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isTrivial(@NotNull UMethod method, @Nullable Predicate<? super UExpression> trivialPredicate) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(11);
        }
        if (method.getJavaPsi().hasModifier(JvmModifier.NATIVE)) {
            return false;
        }
        return MethodUtils.isTrivial(method.getUastBody(), trivialPredicate);
    }

    public static boolean isTrivial(@NotNull UClassInitializer initializer) {
        if (initializer == null) {
            MethodUtils.$$$reportNull$$$0(12);
        }
        return MethodUtils.isTrivial(initializer.getUastBody(), null);
    }

    private static boolean isTrivial(@Nullable UExpression bodyExpression, @Nullable Predicate<? super UExpression> trivialPredicate) {
        if (bodyExpression == null) {
            return true;
        }
        List expressions = bodyExpression instanceof UBlockExpression ? ((UBlockExpression)bodyExpression).getExpressions() : List.of(bodyExpression);
        if (expressions.isEmpty()) {
            return true;
        }
        for (UExpression expression : expressions) {
            ProgressManager.checkCanceled();
            if (expression instanceof UastEmptyExpression || trivialPredicate != null && trivialPredicate.test((UExpression)expression)) continue;
            if (expression instanceof UReturnExpression) {
                UReturnExpression returnExpression = (UReturnExpression)expression;
                UExpression returnedExpression = returnExpression.getReturnExpression();
                if (returnedExpression == null || UastUtils.skipParenthesizedExprDown((UExpression)returnedExpression) instanceof ULiteralExpression) continue;
                return false;
            }
            if (expression instanceof UIfExpression) {
                UIfExpression ifExpression = (UIfExpression)expression;
                UExpression condition = ifExpression.getCondition();
                Object result = condition.evaluate();
                if (result != null && result.equals(Boolean.FALSE)) continue;
                return false;
            }
            if (expression instanceof UCallExpression) {
                String methodName = ((UCallExpression)expression).getMethodName();
                if (methodName == null || methodName.equals("super") || methodName.equals("<init>")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean hasInThrows(@NotNull PsiMethod method, String ... exceptions) {
        PsiJavaCodeReferenceElement[] references;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(13);
        }
        if (exceptions == null) {
            MethodUtils.$$$reportNull$$$0(14);
        }
        if (exceptions.length == 0) {
            throw new IllegalArgumentException("no exceptions specified");
        }
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
            PsiClass aClass;
            String qualifiedName;
            ProgressManager.checkCanceled();
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass) || !ArrayUtil.contains((String)(qualifiedName = (aClass = (PsiClass)target).getQualifiedName()), (String[])exceptions)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChainable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType()), (boolean)true)) {
            return false;
        }
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
        if (!(lastStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)lastStatement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return returnValue instanceof PsiThisExpression;
    }

    public static boolean haveEquivalentModifierLists(PsiMethod method, PsiMethod superMethod) {
        PsiModifierList list1 = method.getModifierList();
        PsiModifierList list2 = superMethod.getModifierList();
        if (list1.hasModifierProperty("strictfp") != list2.hasModifierProperty("strictfp") || list1.hasModifierProperty("synchronized") != list2.hasModifierProperty("synchronized") || list1.hasModifierProperty("public") != list2.hasModifierProperty("public") || list1.hasModifierProperty("protected") != list2.hasModifierProperty("protected") || list1.hasModifierProperty("final") != list2.hasModifierProperty("final") || list1.hasModifierProperty("abstract") != list2.hasModifierProperty("abstract")) {
            return false;
        }
        return AnnotationUtil.equal((PsiAnnotation[])list1.getAnnotations(), (PsiAnnotation[])list2.getAnnotations());
    }

    @NotNull
    public static PsiMethod findSpecificMethod(@NotNull PsiMethod method, @Nullable PsiType specificType) {
        PsiClass qualifierClass;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(15);
        }
        if ((qualifierClass = method.getContainingClass()) == null) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                MethodUtils.$$$reportNull$$$0(16);
            }
            return psiMethod;
        }
        if (specificType == null || specificType instanceof PsiArrayType) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                MethodUtils.$$$reportNull$$$0(17);
            }
            return psiMethod;
        }
        if (!(specificType instanceof PsiIntersectionType)) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)specificType);
            if (psiClass == null || psiClass.isEquivalentTo((PsiElement)qualifierClass)) {
                PsiMethod psiMethod = method;
                if (psiMethod == null) {
                    MethodUtils.$$$reportNull$$$0(18);
                }
                return psiMethod;
            }
            PsiMethod realMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)psiClass, (PsiMethod)method, (boolean)true);
            PsiMethod psiMethod = Objects.requireNonNullElse(realMethod, method);
            if (psiMethod == null) {
                MethodUtils.$$$reportNull$$$0(19);
            }
            return psiMethod;
        }
        PsiIntersectionType intersectionType = (PsiIntersectionType)specificType;
        List methods = ((StreamEx)((StreamEx)StreamEx.of((Object[])intersectionType.getConjuncts()).map(PsiUtil::resolveClassInClassTypeOnly).nonNull().without((Object)qualifierClass).distinct()).map(specificClass -> MethodSignatureUtil.findMethodBySuperMethod((PsiClass)specificClass, (PsiMethod)method, (boolean)true)).nonNull().distinct()).toList();
        if (methods.isEmpty()) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                MethodUtils.$$$reportNull$$$0(20);
            }
            return psiMethod;
        }
        PsiMethod best = (PsiMethod)methods.getFirst();
        for (PsiMethod realMethod : methods) {
            if (best.equals((Object)realMethod)) continue;
            if (MethodSignatureUtil.isSuperMethod((PsiMethod)best, (PsiMethod)realMethod)) {
                best = realMethod;
                continue;
            }
            if (MethodSignatureUtil.isSuperMethod((PsiMethod)realMethod, (PsiMethod)best)) continue;
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                MethodUtils.$$$reportNull$$$0(21);
            }
            return psiMethod;
        }
        PsiMethod psiMethod = best;
        if (psiMethod == null) {
            MethodUtils.$$$reportNull$$$0(22);
        }
        return psiMethod;
    }

    public static boolean isFactoryMethod(PsiMethod method) {
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
        return aClass != null && aClass.equals((Object)method.getContainingClass());
    }

    public static boolean isConvenienceOverload(PsiMethod method) {
        PsiType returnType = method.getReturnType();
        PsiCodeBlock body = method.getBody();
        PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body);
        if (statement == null) {
            return false;
        }
        if (PsiTypes.voidType().equals((Object)returnType)) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            return MethodUtils.isCallToOverloadedMethod(expression, method);
        }
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return MethodUtils.isCallToOverloadedMethod(returnValue, method);
    }

    private static boolean isCallToOverloadedMethod(PsiExpression expression, PsiMethod method) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        String name = methodCallExpression.getMethodExpression().getReferenceName();
        if (!method.getName().equals(name)) {
            return false;
        }
        PsiMethod calledMethod = methodCallExpression.resolveMethod();
        if (calledMethod == null || calledMethod.getParameterList().getParametersCount() < method.getParameterList().getParametersCount()) {
            return false;
        }
        return calledMethod.getContainingClass() == method.getContainingClass();
    }

    public static boolean hasCanIgnoreReturnValueAnnotation(@NotNull PsiMethod method, @Nullable PsiElement stopElement) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(23);
        }
        return MethodUtils.findAnnotationInTree((PsiElement)method, stopElement, CAN_IGNORE_RETURN_VALUE_ANNOTATIONS) != null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInTree(PsiElement element, @Nullable PsiElement stop, final @NotNull Set<String> fqAnnotationNames) {
        if (fqAnnotationNames == null) {
            MethodUtils.$$$reportNull$$$0(24);
        }
        while (element != null) {
            PsiModifierListOwner modifierListOwner;
            PsiAnnotation annotation;
            if (element == stop) {
                return null;
            }
            if (element instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)(modifierListOwner = (PsiModifierListOwner)element), fqAnnotationNames)) != null) {
                return annotation;
            }
            if (element instanceof PsiFile) {
                PsiFile classOwner = (PsiFile)element;
                var processor = new JavaPsiAnnotationUtil.PackageAnnotationProcessor(){
                    PsiAnnotation myAnnotation = null;

                    public void process(@NotNull PsiAnnotation annotation, boolean superPackage) {
                        if (annotation == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (fqAnnotationNames.contains(annotation.getQualifiedName())) {
                            this.myAnnotation = annotation;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/siyeh/ig/psiutils/MethodUtils$1", "process"));
                    }
                };
                JavaPsiAnnotationUtil.processPackageAnnotations((PsiFile)classOwner, (JavaPsiAnnotationUtil.PackageAnnotationProcessor)processor, (boolean)false);
                return processor.myAnnotation;
            }
            element = element.getContext();
        }
        return null;
    }

    @Nullable
    public static PsiMethod getJavaMethodFromHeader(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element.getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (psiMethod != null && (element == psiMethod || element == psiMethod.getNameIdentifier() || PsiTreeUtil.isAncestor((PsiElement)psiMethod.getModifierList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiMethod.getParameterList(), (PsiElement)element, (boolean)false))) {
            return psiMethod;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17, 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/MethodUtils";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqAnnotationNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/MethodUtils";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpecificMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMethodBody";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "methodMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "simpleMethodMatches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasSuper";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuper";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethodSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOverridden";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOverriddenInHierarchy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTrivial";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasInThrows";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSpecificMethod";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasCanIgnoreReturnValueAnnotation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17, 18, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

