/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class StatementExtractor {
    private static final Node EMPTY = new Node(null){

        @Override
        public Node prepend(Node node) {
            return node;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    public static PsiStatement @NotNull [] generateStatements(List<? extends PsiExpression> expressionsToKeep, PsiExpression root) {
        String statementsCode = StatementExtractor.generateStatementsText(expressionsToKeep, root);
        if (statementsCode.isEmpty()) {
            if (PsiStatement.EMPTY_ARRAY == null) {
                StatementExtractor.$$$reportNull$$$0(0);
            }
            return PsiStatement.EMPTY_ARRAY;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)root.getProject());
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText("{" + statementsCode + "}", (PsiElement)root);
        PsiStatement[] psiStatementArray = codeBlock.getStatements();
        if (psiStatementArray == null) {
            StatementExtractor.$$$reportNull$$$0(1);
        }
        return psiStatementArray;
    }

    public static String generateStatementsText(List<? extends PsiExpression> expressionsToKeep, PsiExpression root) {
        Node result = (Node)StreamEx.ofReversed(expressionsToKeep).map(expression -> StatementExtractor.createNode(expression, root)).foldLeft((Object)EMPTY, Node::prepend);
        return result.toString();
    }

    @NotNull
    private static Node createNode(@NotNull PsiExpression expression, @NotNull PsiExpression root) {
        if (expression == null) {
            StatementExtractor.$$$reportNull$$$0(2);
        }
        if (root == null) {
            StatementExtractor.$$$reportNull$$$0(3);
        }
        Node result = new Expr(expression);
        while (expression != root) {
            PsiSwitchExpression switchExpression;
            PsiElement parentElement = expression.getParent();
            if (parentElement instanceof PsiExpressionList || parentElement instanceof PsiTemplate) {
                parentElement = parentElement.getParent();
            }
            if (parentElement instanceof PsiStatement && (switchExpression = (PsiSwitchExpression)PsiTreeUtil.getParentOfType((PsiElement)parentElement, PsiSwitchExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null && PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)switchExpression, (boolean)false)) {
                boolean isYield = parentElement instanceof PsiYieldStatement && ((PsiYieldStatement)parentElement).findEnclosingExpression() == switchExpression;
                boolean isRuleExpression = parentElement instanceof PsiExpressionStatement && parentElement.getParent() instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)parentElement.getParent()).getEnclosingSwitchBlock() == switchExpression;
                result = isYield || isRuleExpression ? new Switch(switchExpression, Collections.singletonMap((PsiStatement)parentElement, result)) : new Switch(switchExpression, Collections.emptyMap());
                expression = switchExpression;
                continue;
            }
            PsiExpression parent = (PsiExpression)ObjectUtils.tryCast((Object)parentElement, PsiExpression.class);
            if (parent == null) {
                String message = PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression, (boolean)false) ? "Expected to have expression parent, got " + String.valueOf(parentElement.getClass()) : "Supplied root is not the expression ancestor";
                throw new RuntimeExceptionWithAttachments(message, new Attachment[]{new Attachment("expression.txt", expression.getText()), new Attachment("root.txt", root.getText())});
            }
            result = StatementExtractor.foldNode(result, expression, parent);
            expression = parent;
        }
        Expr expr = result;
        if (expr == null) {
            StatementExtractor.$$$reportNull$$$0(4);
        }
        return expr;
    }

    @NotNull
    private static Node foldNode(@NotNull Node node, @NotNull PsiExpression expression, @NotNull PsiExpression parent) {
        if (node == null) {
            StatementExtractor.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            StatementExtractor.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            StatementExtractor.$$$reportNull$$$0(7);
        }
        if (parent instanceof PsiPolyadicExpression) {
            boolean and;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType type = polyadic.getOperationTokenType();
            if (type == JavaTokenType.ANDAND) {
                and = true;
            } else if (type == JavaTokenType.OROR) {
                and = false;
            } else {
                Node node2 = node;
                if (node2 == null) {
                    StatementExtractor.$$$reportNull$$$0(8);
                }
                return node2;
            }
            Object[] operands = polyadic.getOperands();
            int index = ArrayUtil.indexOf((Object[])operands, (Object)expression);
            if (index == 0) {
                Node node3 = node;
                if (node3 == null) {
                    StatementExtractor.$$$reportNull$$$0(9);
                }
                return node3;
            }
            return new Cond(parent, parent, index, and ? node : EMPTY, and ? EMPTY : node);
        }
        if (parent instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)parent;
            if (expression == ternary.getThenExpression()) {
                return new Cond((PsiExpression)ternary, ternary.getCondition(), -1, node, EMPTY);
            }
            if (expression == ternary.getElseExpression()) {
                return new Cond((PsiExpression)ternary, ternary.getCondition(), -1, EMPTY, node);
            }
        }
        Node node4 = node;
        if (node4 == null) {
            StatementExtractor.$$$reportNull$$$0(10);
        }
        return node4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/StatementExtractor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateStatements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/StatementExtractor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "foldNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "foldNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static abstract class Node {
        final PsiExpression myAnchor;

        protected Node(PsiExpression anchor) {
            this.myAnchor = anchor;
        }

        public abstract Node prepend(Node var1);

        public abstract String toString();
    }

    private static final class Expr
    extends Node {
        private Expr(@NotNull PsiExpression expression) {
            if (expression == null) {
                Expr.$$$reportNull$$$0(0);
            }
            super(expression);
        }

        @Override
        public Node prepend(Node node) {
            return node.myAnchor == null ? this : new Cons(node, this);
        }

        @Override
        public String toString() {
            if (this.myAnchor instanceof PsiInstanceOfExpression) {
                List patternVariableWrappers = JavaPsiPatternUtil.collectPatternVariableWrappers((PsiExpression)this.myAnchor);
                StringBuilder sb = new StringBuilder();
                for (JavaPsiPatternUtil.PatternVariableWrapper patternVariableWrapper : patternVariableWrappers) {
                    String initializer = patternVariableWrapper.getEffectiveInitializerText();
                    if (initializer == null) continue;
                    PsiPatternVariable variable = patternVariableWrapper.getVariable();
                    sb.append(variable.getTypeElement().getText()).append(" ").append(variable.getName()).append("=").append(initializer).append(";");
                }
                return sb.toString();
            }
            return this.myAnchor.getText() + ";";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor$Expr", "<init>"));
        }
    }

    private static final class Switch
    extends Node {
        private static final Key<Node> NODE_KEY = Key.create((String)"SwitchNode");
        @NotNull
        private final Map<PsiStatement, Node> myReturns;

        private Switch(@NotNull PsiSwitchExpression expression, @NotNull Map<PsiStatement, Node> sideEffectReturns) {
            if (expression == null) {
                Switch.$$$reportNull$$$0(0);
            }
            if (sideEffectReturns == null) {
                Switch.$$$reportNull$$$0(1);
            }
            super((PsiExpression)expression);
            this.myReturns = sideEffectReturns;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (node instanceof Switch && node.myAnchor == this.myAnchor) {
                if (this.myReturns.isEmpty()) {
                    return node;
                }
                if (((Switch)node).myReturns.isEmpty()) {
                    return this;
                }
                HashMap<PsiStatement, Node> newMap = new HashMap<PsiStatement, Node>(this.myReturns);
                ((Switch)node).myReturns.forEach((statement, n) -> newMap.merge((PsiStatement)statement, (Node)n, Node::prepend));
                return new Switch((PsiSwitchExpression)this.myAnchor, newMap);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            this.myReturns.forEach((statement, node) -> statement.putCopyableUserData(NODE_KEY, node));
            final PsiSwitchExpression copy = (PsiSwitchExpression)this.myAnchor.copy();
            final HashMap<PsiStatement, PsiStatement[]> replacementMap = new HashMap<PsiStatement, PsiStatement[]>();
            final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myAnchor.getProject());
            PsiCodeBlock body = Objects.requireNonNull(copy.getBody());
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

                public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
                    if (statement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (statement.getParent() instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)statement.getParent()).getEnclosingSwitchBlock() == copy) {
                        this.process((PsiStatement)statement);
                    }
                }

                public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
                    if (statement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (statement.getExpression() != null && statement.findEnclosingExpression() == copy) {
                        this.process((PsiStatement)statement);
                    }
                }

                public void visitExpression(@NotNull PsiExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(2);
                    }
                }

                private void process(PsiStatement statement) {
                    Node data = (Node)statement.getCopyableUserData(NODE_KEY);
                    if (data == null) {
                        replacementMap.put(statement, PsiStatement.EMPTY_ARRAY);
                    } else {
                        replacementMap.put(statement, factory.createCodeBlockFromText("{" + String.valueOf(data) + "}", (PsiElement)statement).getStatements());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "statement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                    }
                    objectArray2[1] = "com/siyeh/ig/psiutils/StatementExtractor$Switch$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitExpressionStatement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitYieldStatement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            replacementMap.forEach((statement, replacements) -> {
                boolean keep;
                boolean bl = keep = statement instanceof PsiYieldStatement && this.shouldKeepBreak((PsiStatement)statement);
                if (!keep && ((PsiStatement[])replacements).length == 1) {
                    statement.replace((PsiElement)replacements[0]);
                } else {
                    if (!keep || ((PsiStatement[])replacements).length > 0) {
                        if (!(statement.getParent() instanceof PsiCodeBlock)) {
                            statement = BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)statement);
                        }
                        PsiElement parent = statement.getParent();
                        for (PsiStatement replacement : replacements) {
                            parent.addBefore((PsiElement)replacement, (PsiElement)statement);
                        }
                    }
                    if (!keep) {
                        statement.delete();
                    } else {
                        statement.replace((PsiElement)factory.createStatementFromText("break;", null));
                    }
                }
            });
            return copy.getText();
        }

        public boolean shouldKeepBreak(PsiStatement statement) {
            if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement) instanceof PsiStatement) {
                return true;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiBlockStatement) {
                    return this.shouldKeepBreak((PsiStatement)gParent);
                }
            } else {
                if (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement) {
                    return this.shouldKeepBreak((PsiStatement)parent);
                }
                if (parent instanceof PsiSwitchLabeledRuleStatement) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sideEffectReturns";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Switch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Cond
    extends Node {
        @NotNull
        private final PsiExpression myCondition;
        @NotNull
        private final Node myThenBranch;
        @NotNull
        private final Node myElseBranch;
        private final int myLimit;

        private Cond(@NotNull PsiExpression anchor, @NotNull PsiExpression condition, int limit, @NotNull Node thenBranch, @NotNull Node elseBranch) {
            if (anchor == null) {
                Cond.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                Cond.$$$reportNull$$$0(1);
            }
            if (thenBranch == null) {
                Cond.$$$reportNull$$$0(2);
            }
            if (elseBranch == null) {
                Cond.$$$reportNull$$$0(3);
            }
            super(anchor);
            this.myCondition = condition;
            this.myLimit = limit;
            assert (limit < 0 || condition instanceof PsiPolyadicExpression);
            this.myThenBranch = thenBranch;
            this.myElseBranch = elseBranch;
        }

        private String getCondition(boolean invert) {
            if (this.myLimit < 0) {
                return invert ? BoolUtils.getNegatedExpressionText(this.myCondition) : this.myCondition.getText();
            }
            PsiPolyadicExpression condition = (PsiPolyadicExpression)this.myCondition;
            Object[] operands = condition.getOperands();
            String joiner = condition.getOperationTokenType() == JavaTokenType.ANDAND != invert ? "&&" : "||";
            return StreamEx.of((Object[])operands, (int)0, (int)this.myLimit).map(invert ? BoolUtils::getNegatedExpressionText : PsiElement::getText).joining((CharSequence)joiner);
        }

        @Override
        @NlsSafe
        public String toString() {
            if (this.myThenBranch == EMPTY) {
                return "if(" + this.getCondition(true) + ") {" + String.valueOf(this.myElseBranch) + "}";
            }
            return "if(" + this.getCondition(false) + ") {" + String.valueOf(this.myThenBranch) + "}" + (String)(this.myElseBranch == EMPTY ? "" : "else {" + String.valueOf(this.myElseBranch) + "}");
        }

        @Override
        public Node prepend(Node node) {
            PsiExpression thatAnchor = node.myAnchor;
            if (thatAnchor == null) {
                return this;
            }
            if (thatAnchor == this.myAnchor) {
                assert (node instanceof Cond);
                Cond cond = (Cond)node;
                assert (this.myCondition == cond.myCondition);
                if (this.myLimit == cond.myLimit) {
                    return new Cond(this.myAnchor, this.myCondition, this.myLimit, this.myThenBranch.prepend(cond.myThenBranch), this.myElseBranch.prepend(cond.myElseBranch));
                }
                assert (this.myLimit > cond.myLimit);
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myCondition, (PsiElement)thatAnchor, (boolean)false)) {
                return this;
            }
            return new Cons(node, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thenBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elseBranch";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Cond";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Cons
    extends Node {
        @NotNull
        private final Node myHead;
        @NotNull
        private final Node myTail;

        private Cons(@NotNull Node head, @NotNull Node tail) {
            if (head == null) {
                Cons.$$$reportNull$$$0(0);
            }
            if (tail == null) {
                Cons.$$$reportNull$$$0(1);
            }
            super(head.myAnchor);
            assert (!(head instanceof Cons));
            this.myHead = head;
            this.myTail = tail;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myHead.myAnchor, (PsiElement)node.myAnchor, (boolean)false)) {
                Node newHead = this.myHead.prepend(node);
                return new Cons(newHead, this.myTail);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myHead.toString() + String.valueOf(this.myTail);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "head";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tail";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Cons";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

