/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class AssertMessageNotStringInspection
extends BaseInspection {
    public boolean onlyWarnOnBoolean = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("assert.message.of.type.boolean.problem.descriptor", type.getPresentableText());
        if (string == null) {
            AssertMessageNotStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyWarnOnBoolean", (String)InspectionGadgetsBundle.message("assert.message.not.string.only.warn.boolean.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            AssertMessageNotStringInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ASSERTIONS);
        if (set == null) {
            AssertMessageNotStringInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AssertMessageNotStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/AssertMessageNotStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AssertMessageNotStringVisitor
    extends BaseInspectionVisitor {
        private AssertMessageNotStringVisitor() {
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement == null) {
                AssertMessageNotStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssertStatement(statement);
            PsiExpression assertDescription = statement.getAssertDescription();
            if (assertDescription == null) {
                return;
            }
            PsiType type = assertDescription.getType();
            if (AssertMessageNotStringInspection.this.onlyWarnOnBoolean) {
                if (PsiTypes.booleanType().equals((Object)type)) {
                    this.registerError((PsiElement)assertDescription, type);
                    return;
                }
                PsiClassType javaLangBoolean = PsiTypes.booleanType().getBoxedType((PsiElement)statement);
                if (javaLangBoolean != null && javaLangBoolean.equals((Object)type)) {
                    this.registerError((PsiElement)assertDescription, type);
                }
            } else if (type != null && !type.equalsToText("java.lang.String")) {
                this.registerError((PsiElement)assertDescription, type);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/style/AssertMessageNotStringInspection$AssertMessageNotStringVisitor", "visitAssertStatement"));
        }
    }
}

