/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LiteralAsArgToStringEqualsInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String methodName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.problem.descriptor", methodName);
        if (string == null) {
            LiteralAsArgToStringEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LiteralAsArgToEqualsVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        String methodName = (String)infos[0];
        return new SwapEqualsFix(methodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection", "buildErrorString"));
    }

    private static class LiteralAsArgToEqualsVisitor
    extends BaseInspectionVisitor {
        private LiteralAsArgToEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                LiteralAsArgToEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName) && !"equalsIgnoreCase".equals(methodName)) {
                return;
            }
            PsiExpression[] arguments = expression.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!(PsiUtil.skipParenthesizedExprDown((PsiExpression)argument) instanceof PsiLiteralExpression)) {
                return;
            }
            if (!TypeUtils.isJavaLangString(argument.getType())) {
                return;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiLiteralExpression) {
                return;
            }
            if (!TypeUtils.isJavaLangString(qualifier.getType())) {
                return;
            }
            this.registerError((PsiElement)argument, methodName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection$LiteralAsArgToEqualsVisitor", "visitMethodCallExpression"));
        }
    }

    private static class SwapEqualsFix
    extends PsiUpdateModCommandQuickFix {
        private final String myMethodName;

        SwapEqualsFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.flip.quickfix", this.myMethodName);
            if (string == null) {
                SwapEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("swap.equals.fix.family.name", new Object[0]);
            if (string == null) {
                SwapEqualsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                SwapEqualsFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                SwapEqualsFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                SwapEqualsFix.$$$reportNull$$$0(4);
            }
            PsiExpression argument = (PsiExpression)startElement;
            PsiElement argumentList = PsiUtil.skipParenthesizedExprUp((PsiElement)argument.getParent());
            PsiMethodCallExpression expression = (PsiMethodCallExpression)argumentList.getParent();
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression strippedQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
            PsiExpression strippedArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)argument);
            if (strippedArgument == null || qualifier == null || strippedQualifier == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.grabComments((PsiElement)qualifier);
            tracker.markUnchanged(strippedQualifier);
            tracker.grabComments((PsiElement)argument);
            tracker.markUnchanged(strippedArgument);
            PsiElement newArgument = strippedQualifier.copy();
            methodExpression.setQualifierExpression(strippedArgument);
            argument.replace(newArgument);
            tracker.insertCommentsBefore((PsiElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection$SwapEqualsFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection$SwapEqualsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

