/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public final class RedundantFieldInitializationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean onlyWarnOnNull = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.field.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantFieldInitializationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyWarnOnNull", (String)JavaAnalysisBundle.message((String)"inspection.redundant.field.initialization.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RedundantFieldInitializationInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RedundantFieldInitializationFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantFieldInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/RedundantFieldInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RedundantFieldInitializationFix
    extends PsiUpdateModCommandQuickFix {
        private RedundantFieldInitializationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.field.initialization.remove.quickfix", new Object[0]);
            if (string == null) {
                RedundantFieldInitializationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                RedundantFieldInitializationFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                RedundantFieldInitializationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RedundantFieldInitializationFix.$$$reportNull$$$0(3);
            }
            startElement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class RedundantFieldInitializationVisitor
    extends BaseInspectionVisitor {
        private RedundantFieldInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                RedundantFieldInitializationVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasInitializer() || field.hasModifierProperty("final")) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiType type = field.getType();
            if (PsiTypes.booleanType().equals((Object)type) ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer), false) : (type instanceof PsiPrimitiveType ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !ExpressionUtils.isZero(initializer) : !PsiTypes.nullType().equals(initializer.getType()))) {
                return;
            }
            if (initializer instanceof PsiReferenceExpression || !PsiTreeUtil.findChildrenOfType((PsiElement)initializer, PsiReferenceExpression.class).isEmpty()) {
                return;
            }
            if (RedundantFieldInitializationVisitor.isAssignmentInInitializerOverwritten(field)) {
                return;
            }
            this.registerError((PsiElement)initializer, new Object[0]);
        }

        private static boolean isAssignmentInInitializerOverwritten(@NotNull PsiField field) {
            PsiClassInitializer[] initializers;
            PsiClass aClass;
            if (field == null) {
                RedundantFieldInitializationVisitor.$$$reportNull$$$0(1);
            }
            if ((aClass = field.getContainingClass()) == null) {
                return false;
            }
            boolean isStatic = field.hasModifierProperty("static");
            for (PsiClassInitializer classInitializer : initializers = aClass.getInitializers()) {
                if (classInitializer.hasModifierProperty("static") != isStatic || classInitializer.getTextOffset() >= field.getTextOffset() || !VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)classInitializer)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "field";
            objectArray2[1] = "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAssignmentInInitializerOverwritten";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

