/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryCallToStringValueOfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NonNls
    private static final CallMatcher STATIC_TO_STRING_CONVERTERS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("boolean"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("char"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("double"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("float"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("int"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("long"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("java.lang.Object"), CallMatcher.staticCall("java.lang.Boolean", "toString").parameterTypes("boolean"), CallMatcher.staticCall("java.lang.Byte", "toString").parameterTypes("byte"), CallMatcher.staticCall("java.lang.Short", "toString").parameterTypes("short"), CallMatcher.staticCall("java.lang.Character", "toString").parameterTypes("char"), CallMatcher.staticCall("java.lang.Integer", "toString").parameterTypes("int"), CallMatcher.staticCall("java.lang.Long", "toString").parameterTypes("long"), CallMatcher.staticCall("java.lang.Float", "toString").parameterTypes("float"), CallMatcher.staticCall("java.lang.Double", "toString").parameterTypes("double"), CallMatcher.staticCall("java.util.Objects", "toString").parameterTypes("java.lang.Object"));
    public boolean reportWithEmptyString = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos[1] == Boolean.TRUE) {
            String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.empty.string.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"reportWithEmptyString", (String)InspectionGadgetsBundle.message("unnecessary.tostring.call.option.report.with.empty.string", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        String text = (String)infos[0];
        Boolean useEmptyString = (Boolean)infos[1];
        return new UnnecessaryCallToStringValueOfFix(text, useEmptyString);
    }

    private static String calculateReplacementText(@NotNull PsiMethodCallExpression call, PsiExpression expression, boolean withEmptyString) {
        if (call == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(3);
        }
        if (withEmptyString) {
            Object text = ParenthesesUtils.getText(expression, 6);
            text = "\"\" + " + (String)text;
            return text;
        }
        if (!(expression instanceof PsiPolyadicExpression)) {
            return expression.getText();
        }
        PsiPolyadicExpression parentCall = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)ParenthesesUtils.getParentSkipParentheses((PsiElement)call), PsiPolyadicExpression.class);
        if (parentCall == null) {
            return expression.getText();
        }
        PsiType type = expression.getType();
        int precedence = ParenthesesUtils.getPrecedence(expression);
        if (TypeUtils.typeEquals("java.lang.String", type) || precedence < 6 || precedence == 6 && ArrayUtil.getFirstElement((Object[])parentCall.getOperands()) == call) {
            return expression.getText();
        }
        return "(" + expression.getText() + ")";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryCallToStringValueOfVisitor();
    }

    @Nullable
    private static PsiExpression getArgument(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(4);
        }
        if (!STATIC_TO_STRING_CONVERTERS.test(call)) {
            return null;
        }
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
    }

    private static boolean couldBeUnwrappedRedundantConversion(@NotNull PsiExpression argument, @NotNull PsiMethodCallExpression call) {
        boolean throwable;
        PsiType argumentType;
        if (argument == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(5);
        }
        if (call == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(6);
        }
        if ((argumentType = argument.getType()) instanceof PsiPrimitiveType) {
            PsiMethod method = call.resolveMethod();
            assert (method != null);
            if (!Objects.requireNonNull(method.getParameterList().getParameter(0)).getType().equals(argumentType)) {
                return false;
            }
        }
        if (ExpressionUtils.isConversionToStringNecessary((PsiExpression)call, throwable = TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable"), argumentType) && (!TypeUtils.isJavaLangString(argumentType) || NullabilityUtil.getExpressionNullability(argument, true) != Nullability.NOT_NULL)) {
            return false;
        }
        return !UnnecessaryCallToStringValueOfInspection.isReplacementAmbiguous(call, argument);
    }

    private static boolean isReplacementAmbiguous(PsiMethodCallExpression call, PsiExpression argument) {
        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)argument)) {
            return false;
        }
        PsiExpressionList exprList = (PsiExpressionList)ObjectUtils.tryCast((Object)ParenthesesUtils.getParentSkipParentheses((PsiElement)call), PsiExpressionList.class);
        if (exprList == null) {
            return false;
        }
        PsiCallExpression parentCall = (PsiCallExpression)ObjectUtils.tryCast((Object)exprList.getParent(), PsiCallExpression.class);
        if (parentCall == null) {
            return false;
        }
        PsiCallExpression copy = (PsiCallExpression)parentCall.copy();
        int argIndex = ContainerUtil.indexOf(Arrays.asList(exprList.getExpressions()), expr -> PsiUtil.skipParenthesizedExprDown((PsiExpression)expr) == call);
        assert (argIndex >= -1);
        PsiExpression argCopy = Objects.requireNonNull(copy.getArgumentList()).getExpressions()[argIndex];
        argCopy.replace((PsiElement)argument);
        JavaResolveResult result = copy.resolveMethodGenerics();
        return !result.isValidResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArgument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "couldBeUnwrappedRedundantConversion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static class UnnecessaryCallToStringValueOfFix
    extends PsiUpdateModCommandQuickFix {
        private final String replacementText;
        private final boolean useEmptyString;

        UnnecessaryCallToStringValueOfFix(String replacementText, boolean useEmptyString) {
            this.replacementText = replacementText;
            this.useEmptyString = useEmptyString;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementText});
            if (string == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(4);
            }
            if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)startElement, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression arg = UnnecessaryCallToStringValueOfInspection.getArgument(call);
            if (arg == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            boolean couldBeUnwrappedRedundantConversion = UnnecessaryCallToStringValueOfInspection.couldBeUnwrappedRedundantConversion(arg, call);
            if (!couldBeUnwrappedRedundantConversion && !this.useEmptyString) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)call, UnnecessaryCallToStringValueOfInspection.calculateReplacementText(call, tracker.markUnchanged(arg), !couldBeUnwrappedRedundantConversion), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection$UnnecessaryCallToStringValueOfFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection$UnnecessaryCallToStringValueOfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnnecessaryCallToStringValueOfVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryCallToStringValueOfVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiExpression argument;
            if (call == null) {
                UnnecessaryCallToStringValueOfVisitor.$$$reportNull$$$0(0);
            }
            if ((argument = UnnecessaryCallToStringValueOfInspection.getArgument(call)) == null) {
                return;
            }
            if (!UnnecessaryCallToStringValueOfInspection.couldBeUnwrappedRedundantConversion(argument, call)) {
                ProblemHighlightType highlightType;
                ProblemHighlightType problemHighlightType = highlightType = UnnecessaryCallToStringValueOfInspection.this.reportWithEmptyString ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION;
                if (highlightType == ProblemHighlightType.INFORMATION && !this.isOnTheFly()) {
                    return;
                }
                this.registerErrorAtOffset((PsiElement)call, 0, call.getArgumentList().getStartOffsetInParent(), highlightType, new Object[]{UnnecessaryCallToStringValueOfInspection.calculateReplacementText(call, argument, true), Boolean.TRUE});
                return;
            }
            this.registerErrorAtOffset((PsiElement)call, 0, call.getArgumentList().getStartOffsetInParent(), UnnecessaryCallToStringValueOfInspection.calculateReplacementText(call, argument, false), Boolean.FALSE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection$UnnecessaryCallToStringValueOfVisitor", "visitMethodCallExpression"));
        }
    }
}

