/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ConstantAssertArgumentInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> ASSERT_METHODS = Set.of("assertTrue", "assertFalse", "assertNull", "assertNotNull");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.junit.assert.argument.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantAssertArgumentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantAssertArgumentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/ConstantAssertArgumentInspection", "buildErrorString"));
    }

    private static class ConstantAssertArgumentVisitor
    extends BaseInspectionVisitor {
        private ConstantAssertArgumentVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            AssertHint assertHint;
            if (expression == null) {
                ConstantAssertArgumentVisitor.$$$reportNull$$$0(0);
            }
            if ((assertHint = AssertHint.create(expression, (Function1<? super String, Integer>)((Function1)methodName -> ASSERT_METHODS.contains(methodName) ? Integer.valueOf(1) : null))) == null) {
                return;
            }
            PsiExpression argument = assertHint.getFirstArgument();
            if (!PsiUtil.isConstantExpression((PsiExpression)argument)) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/ConstantAssertArgumentInspection$ConstantAssertArgumentVisitor", "visitMethodCallExpression"));
        }
    }
}

