/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.AbstractReplaceWithAnotherMethodCallFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ConditionSignalInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToSignalInsteadOfSignalAll";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("condition.signal.problem.descriptor", new Object[0]);
        if (string == null) {
            ConditionSignalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionSignalVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ConditionSignalFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ConditionSignalInspection", "buildErrorString"));
    }

    private static class ConditionSignalVisitor
    extends BaseInspectionVisitor {
        private ConditionSignalVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ConditionSignalVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            @NonNls String signal = "signal";
            if (!"signal".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.concurrent.locks.Condition")) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ConditionSignalInspection$ConditionSignalVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ConditionSignalFix
    extends AbstractReplaceWithAnotherMethodCallFix {
        private ConditionSignalFix() {
        }

        @Override
        @NonNls
        protected String getMethodName() {
            return "signalAll";
        }
    }
}

