/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public final class NotifyWithoutCorrespondingWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("notify.without.corresponding.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            NotifyWithoutCorrespondingWaitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWithoutCorrespondingNotifyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NotifyWithoutCorrespondingWaitInspection", "buildErrorString"));
    }

    private static class WaitWithoutCorrespondingNotifyVisitor
    extends BaseInspectionVisitor {
        private WaitWithoutCorrespondingNotifyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                WaitWithoutCorrespondingNotifyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)fieldClass, (PsiElement)expression, (boolean)true)) {
                return;
            }
            if (WaitWithoutCorrespondingNotifyVisitor.containsWaitCall(fieldClass, field)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean containsWaitCall(PsiClass fieldClass, PsiField field) {
            ContainsWaitVisitor visitor2 = new ContainsWaitVisitor(field);
            fieldClass.accept((PsiElementVisitor)visitor2);
            return visitor2.containsWait();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/NotifyWithoutCorrespondingWaitInspection$WaitWithoutCorrespondingNotifyVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ContainsWaitVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiField target;
        private boolean containsWait;

        ContainsWaitVisitor(PsiField target) {
            this.target = target;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ContainsWaitVisitor.$$$reportNull$$$0(0);
            }
            if (this.containsWait) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ContainsWaitVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isWaitCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (referent == null) {
                return;
            }
            if (!this.target.equals((Object)referent)) {
                return;
            }
            this.containsWait = true;
        }

        boolean containsWait() {
            return this.containsWait;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/NotifyWithoutCorrespondingWaitInspection$ContainsWaitVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

