/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import org.jetbrains.annotations.NotNull;

public final class PublicFieldAccessedInSynchronizedContextInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonPrivateFieldAccessedInSynchronizedContext";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.field.accessed.in.synchronized.context.problem.descriptor", new Object[0]);
        if (string == null) {
            PublicFieldAccessedInSynchronizedContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldAccessedInSynchronizedContextVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/PublicFieldAccessedInSynchronizedContextInspection", "buildErrorString"));
    }

    private static class PublicFieldAccessedInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private PublicFieldAccessedInSynchronizedContextVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiExpression qualifier;
            if (expression == null) {
                PublicFieldAccessedInSynchronizedContextVisitor.$$$reportNull$$$0(0);
            }
            if ((qualifier = expression.getQualifierExpression()) != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return;
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("private") || field.hasModifierProperty("final")) {
                return;
            }
            if (!SynchronizationUtil.isInSynchronizedContext((PsiElement)expression)) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || containingClass.hasModifierProperty("private")) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/PublicFieldAccessedInSynchronizedContextInspection$PublicFieldAccessedInSynchronizedContextVisitor", "visitReferenceExpression"));
        }
    }
}

