/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class UnconditionalWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unconditional.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            UnconditionalWaitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnconditionalWaitVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/UnconditionalWaitInspection", "buildErrorString"));
    }

    private static class UnconditionalWaitVisitor
    extends BaseInspectionVisitor {
        private UnconditionalWaitVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                UnconditionalWaitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                UnconditionalWaitVisitor.$$$reportNull$$$0(1);
            }
            super.visitSynchronizedStatement(statement);
            PsiCodeBlock body = statement.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        private void checkBody(PsiCodeBlock body) {
            PsiStatement[] statements;
            for (PsiStatement statement : statements = body.getStatements()) {
                PsiType parameterType;
                PsiParameterList parameterList;
                int numParams;
                PsiMethod method;
                PsiMethodCallExpression methodCallExpression;
                PsiReferenceExpression methodExpression;
                String methodName;
                PsiExpression firstExpression;
                if (UnconditionalWaitVisitor.isConditional(statement)) {
                    return;
                }
                if (!(statement instanceof PsiExpressionStatement) || !((firstExpression = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression) || !"wait".equals(methodName = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)firstExpression).getMethodExpression()).getReferenceName()) || (method = methodCallExpression.resolveMethod()) == null || (numParams = (parameterList = method.getParameterList()).getParametersCount()) > 2) continue;
                PsiParameter[] parameters = parameterList.getParameters();
                if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiTypes.longType()) || numParams > 1 && !(parameterType = parameters[1].getType()).equals(PsiTypes.intType())) continue;
                this.registerMethodCallError(methodCallExpression, new Object[0]);
            }
        }

        private static boolean isConditional(PsiStatement statement) {
            return statement instanceof PsiIfStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/UnconditionalWaitInspection$UnconditionalWaitVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

