/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public final class WaitCalledOnConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("wait.called.on.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            WaitCalledOnConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new WaitCalledOnConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitCalledOnConditionInspection", "buildErrorString"));
    }

    private static class WaitCalledOnConditionVisitor
    extends BaseInspectionVisitor {
        private WaitCalledOnConditionVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                WaitCalledOnConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isWaitCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.concurrent.locks.Condition")) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/WaitCalledOnConditionInspection$WaitCalledOnConditionVisitor", "visitMethodCallExpression"));
        }
    }
}

