/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class WaitWhileHoldingTwoLocksInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("wait.while.holding.two.locks.problem.descriptor", new Object[0]);
        if (string == null) {
            WaitWhileHoldingTwoLocksInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWhileHoldingTwoLocksVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection", "buildErrorString"));
    }

    private static class WaitWhileHoldingTwoLocksVisitor
    extends BaseInspectionVisitor {
        private WaitWhileHoldingTwoLocksVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                WaitWhileHoldingTwoLocksVisitor.$$$reportNull$$$0(0);
            }
            this.checkErrorsIn((PsiElement)method);
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                WaitWhileHoldingTwoLocksVisitor.$$$reportNull$$$0(1);
            }
            this.checkErrorsIn((PsiElement)initializer);
        }

        private void checkErrorsIn(PsiElement context) {
            context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                private int m_numLocksHeld;

                public void visitClass(@NotNull PsiClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    PsiType parameterType;
                    if (expression == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.visitMethodCallExpression(expression);
                    if (this.m_numLocksHeld < 2) {
                        return;
                    }
                    PsiReferenceExpression methodExpression = expression.getMethodExpression();
                    @NonNls String methodName = methodExpression.getReferenceName();
                    if (!"wait".equals(methodName)) {
                        return;
                    }
                    PsiMethod method = expression.resolveMethod();
                    if (method == null) {
                        return;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    int numParams = parameterList.getParametersCount();
                    if (numParams > 2) {
                        return;
                    }
                    PsiParameter[] parameters = parameterList.getParameters();
                    if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiTypes.longType())) {
                        return;
                    }
                    if (numParams > 1 && !(parameterType = parameters[1].getType()).equals(PsiTypes.intType())) {
                        return;
                    }
                    this.registerMethodCallError(expression, new Object[0]);
                }

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (method.hasModifierProperty("synchronized")) {
                        ++this.m_numLocksHeld;
                    }
                    super.visitMethod(method);
                }

                public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement synchronizedStatement) {
                    if (synchronizedStatement == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    ++this.m_numLocksHeld;
                    super.visitSynchronizedStatement(synchronizedStatement);
                }

                protected void elementFinished(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    super.elementFinished(element);
                    if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("synchronized") || element instanceof PsiSynchronizedStatement) {
                        --this.m_numLocksHeld;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "aClass";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "method";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "synchronizedStatement";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClass";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLambdaExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethodCallExpression";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethod";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitSynchronizedStatement";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

