/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.inspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.RegexValidator;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.InheritanceUtil;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.inspection.AbstractToStringInspection;

public final class ClassHasNoToStringMethodInspection
extends AbstractToStringInspection {
    public String excludeClassNames = "";
    private Pattern excludeClassNamesPattern;
    public boolean excludeException = true;
    public boolean excludeDeprecated = true;
    public boolean excludeEnum;
    public boolean excludeAbstract;
    public boolean excludeRecords = true;
    public boolean excludeTestCode;
    public boolean excludeInnerClasses;

    @NotNull
    public String getShortName() {
        return "ClassHasNoToStringMethod";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitClass(@NotNull PsiClass clazz) {
                PsiMethod[] superMethods;
                PsiMethod[] toStringMethods;
                PsiField[] fields;
                PsiIdentifier nameIdentifier;
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (AbstractToStringInspection.LOG.isDebugEnabled()) {
                    AbstractToStringInspection.LOG.debug("checkClass: clazz=" + String.valueOf(clazz));
                }
                if ((nameIdentifier = clazz.getNameIdentifier()) == null || clazz.getName() == null) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeException && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Throwable")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeDeprecated && clazz.isDeprecated()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeEnum && clazz.isEnum()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeRecords && clazz.isRecord()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeAbstract && clazz.hasModifierProperty("abstract")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeTestCode && TestFrameworks.getInstance().isTestClass(clazz)) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeInnerClasses && clazz.getContainingClass() != null) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern != null) {
                    try {
                        String name = clazz.getName();
                        if (name != null && ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern.matcher(name).matches()) {
                            return;
                        }
                    }
                    catch (PatternSyntaxException name) {
                        // empty catch block
                    }
                }
                if ((fields = clazz.getFields()).length == 0) {
                    return;
                }
                fields = GenerateToStringUtils.filterAvailableFields(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                PsiMethod[] methods = null;
                if (GenerateToStringContext.getConfig().isEnableMethods()) {
                    methods = GenerateToStringUtils.filterAvailableMethods(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                }
                if (Math.max(fields.length, methods == null ? 0 : methods.length) == 0) {
                    return;
                }
                for (PsiMethod method : toStringMethods = clazz.findMethodsByName("toString", false)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (!parameterList.isEmpty()) continue;
                    return;
                }
                for (PsiMethod method : superMethods = clazz.findMethodsByName("toString", true)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (!parameterList.isEmpty() || !method.hasModifierProperty("final")) continue;
                    return;
                }
                holder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.description", (Object[])new Object[]{clazz.getName()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/java/generate/inspection/ClassHasNoToStringMethodInspection$1", "visitClass"));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"excludeClassNames", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.exclude.classes.reg.exp.option", (Object[])new Object[0]), (int)30, (StringValidator)new RegexValidator()), OptPane.checkbox((String)"excludeException", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.exception.classes.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"excludeDeprecated", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.deprecated.classes.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"excludeEnum", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.enum.classes.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"excludeRecords", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.records.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"excludeAbstract", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.abstract.classes.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"excludeTestCode", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.test.classes.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"excludeInnerClasses", (String)JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.inner.classes.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValueSet("excludeClassNames", value -> {
            try {
                this.excludeClassNamesPattern = Pattern.compile(this.excludeClassNames);
            }
            catch (PatternSyntaxException ignore) {
                this.excludeClassNamesPattern = null;
            }
        });
        if (optionController == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        try {
            this.excludeClassNamesPattern = Pattern.compile(this.excludeClassNames);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(4);
        }
        DefaultJDOMExternalizer.write((Object)((Object)this), (Element)node, field -> !"excludeRecords".equals(field.getName()) || !this.excludeRecords);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/generate/inspection/ClassHasNoToStringMethodInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/generate/inspection/ClassHasNoToStringMethodInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

