/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.jpa.orm;

import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.GenericGenerator;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.service.JpabReferenceManager;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.orm.CustomLiquibaseModelObjectFactory;
import com.intellij.liquibase.orm.LiquibaseModelObjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;

public class JpaLiquibaseSequenceHelper {
    private final LiquibaseModelObjectFactory dbObjectFactory;
    private Schema schema;
    private final Collection<Sequence> result = new ArrayList<Sequence>();

    public JpaLiquibaseSequenceHelper(PhysicalNamingStrategy namingStrategy, Schema schema) {
        this.dbObjectFactory = new CustomLiquibaseModelObjectFactory(namingStrategy);
        this.schema = schema;
    }

    public Collection<Sequence> compute(Project project, List<Entity> entityList, Boolean dbCheckCondition) {
        HashSet<String> processedSequenceNames = new HashSet<String>();
        for (Entity entity : entityList) {
            EntityAttribute idAttribute;
            Entity parent;
            SequenceGenerator entitySequenceGenerator = entity.getSequenceGenerator();
            if (!entity.isPersistentEntity() || (parent = entity.getParent()) != null && parent.isPersistentEntity() && EntityDesignHelper.getInheritanceType((Entity)entity) == Entity.InheritanceType.SINGLE_TABLE || !JpaLiquibaseSequenceHelper.attributeTypeIsNumber(idAttribute = entity.getIdAttributeOrNull(), entity)) continue;
            String attrSequenceGeneratorName = null;
            if (idAttribute instanceof EntityAttributePsi) {
                attrSequenceGeneratorName = EntityUtil.getSequenceGeneratorName((PsiMember)((EntityAttributePsi)idAttribute).getMember());
            }
            if (!JpaLiquibaseSequenceHelper.isSequenceGenerator(idAttribute, entitySequenceGenerator, attrSequenceGeneratorName, project, dbCheckCondition)) continue;
            boolean isSuitableGenerator = JpabReferenceManager.getInstance((Project)project).isSuitableGenerator(entity);
            SequenceGenerator targetSequenceGenerator = entitySequenceGenerator != null && StringUtil.isEmpty((String)attrSequenceGeneratorName) && isSuitableGenerator ? entitySequenceGenerator : Optional.ofNullable(idAttribute.getGeneratorName()).map(it -> EntityUtil.getEntityWithGenerator((Project)project, (String)it)).map(EntityPsi::getSequenceGenerator).orElseGet(() -> JpaLiquibaseSequenceHelper.createAttrSeqGen(idAttribute, entity, project));
            String sequenceName = targetSequenceGenerator.getSequenceName();
            if (StringUtil.isEmpty((String)sequenceName)) {
                sequenceName = targetSequenceGenerator.getName();
            }
            Schema entitySchema = null;
            if (this.schema == null && StringUtil.isNotEmpty((String)entity.getSchema())) {
                String entityCatalog = entity.getCatalog();
                Catalog catalog = StringUtil.isNotEmpty((String)entityCatalog) ? new Catalog(entityCatalog) : new Catalog();
                entitySchema = new Schema(catalog, entity.getSchema());
            }
            if (!processedSequenceNames.add(sequenceName)) continue;
            Sequence sequence = this.createSequence(project, sequenceName, targetSequenceGenerator.getInitialValue(), targetSequenceGenerator.getAllocationSize(), targetSequenceGenerator.isSystemIdx(), entitySchema);
            this.result.add(sequence);
        }
        return this.result;
    }

    private static boolean attributeTypeIsNumber(EntityAttribute attribute, Entity entity) {
        Datatype datatype;
        if (attribute == null || !((datatype = attribute.getType()) instanceof Datatypes.BasicDatatype)) {
            return false;
        }
        Datatypes.BasicDatatype attributeType = (Datatypes.BasicDatatype)datatype;
        if (attributeType.isNumber()) {
            return true;
        }
        if (!attributeType.isKnownType() && attribute instanceof EntityAttributePsi && ((EntityAttributePsi)attribute).isValid()) {
            PsiClass entityPsiClass;
            PsiMember attrMember = ((EntityAttributePsi)attribute).getMember();
            PsiClass psiClass = entityPsiClass = entity instanceof EntityPsi ? ((EntityPsi)entity).getPsiClass() : null;
            if (entityPsiClass == null) {
                return false;
            }
            Datatype resolvedGenericAttrType = AttributeUtil.getResolvedGenericAttrType((PsiClass)entityPsiClass, (PsiMember)attrMember);
            return resolvedGenericAttrType instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)resolvedGenericAttrType).isNumber();
        }
        return false;
    }

    private static SequenceGenerator createAttrSeqGen(EntityAttribute idAttribute, Entity entity, Project project) {
        Object sequenceName = null;
        String generatorName = idAttribute.getGeneratorName();
        boolean isSystemIdx = false;
        if (StringUtil.isNotEmpty((String)generatorName) && StringUtil.isEmpty((String)(sequenceName = idAttribute.getSequenceOrTableGeneratorName()))) {
            sequenceName = generatorName;
            if (idAttribute.getGeneratedStrategy() == EntityAttribute.GeneratedStrategy.AUTO) {
                isSystemIdx = true;
            }
        }
        if (StringUtil.isEmpty(sequenceName)) {
            sequenceName = EntityUtil.isSequencePerEntityStrategy((Project)project) ? PhysicalNamingStrategy.getInstance((Project)project).toTableName(entity.getTable()) + "_seq" : (JpaUtils.isHibernateProject((Project)project, null) ? "hibernate_sequence" : "seq_gen");
            isSystemIdx = true;
        }
        SequenceGenerator targetSequenceGenerator = new SequenceGenerator(StringUtil.notNullize((String)generatorName), (String)sequenceName, idAttribute.getInitialValue(), idAttribute.getAllocationSize());
        targetSequenceGenerator.setSystemIdx(isSystemIdx);
        return targetSequenceGenerator;
    }

    private static boolean isSequenceGenerator(EntityAttribute idAttribute, SequenceGenerator entitySequenceGenerator, String attrSequenceGeneratorName, Project project, Boolean dbCheckCondition) {
        String sequenceGeneratorName;
        EntityAttributePsi entityAttributePsi;
        String generationStrategy;
        EntityAttribute.GeneratedStrategy generatedStrategy = idAttribute.getGeneratedStrategy();
        if (generatedStrategy == EntityAttribute.GeneratedStrategy.SEQUENCE) {
            return true;
        }
        String generatorName = idAttribute.getGeneratorName();
        if (StringUtil.isEmpty((String)generatorName)) {
            return generatedStrategy == EntityAttribute.GeneratedStrategy.AUTO && JpaUtils.isHibernateProject((Project)project) && dbCheckCondition != false;
        }
        if (generatedStrategy == EntityAttribute.GeneratedStrategy.AUTO && idAttribute instanceof EntityAttributePsi && (generationStrategy = (String)Optional.ofNullable(EntityUtil.getGenericGenerator((PsiModifierListOwner)(entityAttributePsi = (EntityAttributePsi)idAttribute).getMember())).or(() -> Optional.ofNullable(entityAttributePsi.getEntity().getGenericGenerator())).filter(generator -> generatorName.equals(generator.getName())).map(GenericGenerator::getStrategy).orElse(null)) != null && !EntityAttribute.GENERIC_GENERATOR_SEQUENCE_STRATEGIES.contains(generationStrategy)) {
            return false;
        }
        String string = sequenceGeneratorName = entitySequenceGenerator == null ? null : entitySequenceGenerator.getName();
        if (StringUtil.isNotEmpty((String)attrSequenceGeneratorName)) {
            sequenceGeneratorName = attrSequenceGeneratorName;
        } else if (sequenceGeneratorName == null && generatedStrategy == EntityAttribute.GeneratedStrategy.AUTO) {
            return true;
        }
        return StringUtil.equals((CharSequence)sequenceGeneratorName, (CharSequence)generatorName);
    }

    private Sequence createSequence(Project project, String sequenceName, int initialValue, int incrementBy, boolean isSystemIdx, Schema entitySchema) {
        Sequence sequence = this.dbObjectFactory.createSequence(sequenceName);
        sequence.setSchema(this.schema != null ? this.schema : entitySchema);
        if (isSystemIdx) {
            sequence.setStartValue(BigInteger.valueOf(1L));
            sequence.setIncrementBy(BigInteger.valueOf(EntityUtil.getHibernateDefaultIncrementSize((Project)project)));
        } else {
            sequence.setStartValue(BigInteger.valueOf(initialValue));
            sequence.setIncrementBy(BigInteger.valueOf(incrementBy));
        }
        return sequence;
    }
}

