/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.ExternalIntegerKeyDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DuplicatesIndex.class);
    private static final int MAX_COST = 7000;
    private final PersistentHashMap<Integer, List<MyEntry>> myPersistentHashMap;
    private final DuplicatesProfile[] myProfiles;
    @NotNull
    private final Project myProject;

    public DuplicatesIndex(@NotNull Project project, DuplicatesProfile @NotNull [] profiles) throws IOException {
        if (project == null) {
            DuplicatesIndex.J(0);
        }
        if (profiles == null) {
            DuplicatesIndex.J(1);
        }
        this.myProfiles = profiles;
        this.myProject = project;
        File file = ProjectUtil.getProjectCachePath((Project)project, (String)"duplicates").toFile();
        IOUtil.deleteAllFilesStartingWith((File)file);
        this.myPersistentHashMap = new PersistentHashMap(file.toPath(), (KeyDescriptor)ExternalIntegerKeyDescriptor.INSTANCE, (DataExternalizer)new MyDataExternalizer());
        this.myPersistentHashMap.force();
    }

    public void dispose() {
        try {
            this.myPersistentHashMap.closeAndClean();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(@NotNull AnalysisScope scope) {
        if (scope == null) {
            DuplicatesIndex.J(2);
        }
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        final int n2 = scope.getFileCount();
        if (progressIndicator != null) {
            progressIndicator.setText(DupLocatorBundle.message((String)"duplicates.indexing.progress", (Object[])new Object[0]));
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            private int myFileCount = 0;

            public void visitFile(@NotNull PsiFile baseFile) {
                String string;
                Int2ObjectMap<Set<MyEntry>> int2ObjectMap;
                if (baseFile == null) {
                    1.J(0);
                }
                Project project = baseFile.getProject();
                ++this.myFileCount;
                if (progressIndicator != null) {
                    int2ObjectMap = baseFile.getVirtualFile();
                    if (int2ObjectMap != null) {
                        string = int2ObjectMap.getPresentableUrl();
                        String string2 = ProjectUtilCore.displayUrlRelativeToProject(int2ObjectMap, (String)string, (Project)project, (boolean)true, (boolean)false);
                        progressIndicator.setText2(string2);
                    }
                    progressIndicator.setFraction((double)this.myFileCount / (double)n2);
                }
                int2ObjectMap = DuplicatesIndex.this.J(project, baseFile);
                string = int2ObjectMap.keySet().iterator();
                while (string.hasNext()) {
                    int n22 = string.nextInt();
                    Set set = (Set)int2ObjectMap.get(n22);
                    try {
                        ArrayList arrayList = (ArrayList)DuplicatesIndex.this.myPersistentHashMap.get((Object)n22);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.addAll(set);
                        DuplicatesIndex.this.myPersistentHashMap.put((Object)n22, new ArrayList(arrayList));
                    }
                    catch (IOException iOException) {
                        LOG.error((Throwable)iOException);
                    }
                }
            }

            private static /* synthetic */ void J(int n22) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplicatesIndex$1", "visitFile"));
            }
        });
    }

    private Int2ObjectMap<Set<MyEntry>> J(Project project, PsiFile psiFile) {
        try {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return Int2ObjectMaps.emptyMap();
            }
            MyIndexingFragmentsCollector myIndexingFragmentsCollector = new MyIndexingFragmentsCollector();
            DuplocateVisitor[] duplocateVisitorArray = DuplicatesIndex.J(this.myProfiles, myIndexingFragmentsCollector);
            for (PsiFile psiFile2 : psiFile.getViewProvider().getAllFiles()) {
                for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                    duplocateVisitor.visitNode((PsiElement)psiFile2);
                }
                InjectedLanguageManager.getInstance((Project)project).dropFileCaches(psiFile2);
            }
            return myIndexingFragmentsCollector.getResult();
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (RuntimeException runtimeException) {
            LOG.error((Throwable)runtimeException);
            return Int2ObjectMaps.emptyMap();
        }
    }

    public void processAll(@NotNull AnalysisScope scope, @NotNull FragmentsCollector collector) {
        if (scope == null) {
            DuplicatesIndex.J(3);
        }
        if (collector == null) {
            DuplicatesIndex.J(4);
        }
        try {
            IntArrayList intArrayList = new IntArrayList();
            this.myPersistentHashMap.processKeys(arg_0 -> DuplicatesIndex.J((IntList)intArrayList, arg_0));
            final Map<VirtualFile, Map<Language, IntSet>> map = this.J((IntList)intArrayList);
            final DuplocateVisitor[] duplocateVisitorArray = DuplicatesIndex.J(this.myProfiles, new MyProcessingFragmentsCollector(map, collector));
            final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setText(DupLocatorBundle.message((String)"duplicates.searching.progress", (Object[])new Object[0]));
            }
            final int n2 = map.size();
            final Set<VirtualFile> set = map.keySet();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
                private int myIndex = 0;

                public void visitFile(@NotNull PsiFile baseFile) {
                    if (baseFile == null) {
                        2.J(0);
                    }
                    if (!baseFile.isValid()) {
                        return;
                    }
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile == null || !set.contains(virtualFile)) {
                        return;
                    }
                    if (progressIndicator != null) {
                        String string = virtualFile.getPresentableUrl();
                        String string2 = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)string, (Project)DuplicatesIndex.this.myProject, (boolean)true, (boolean)false);
                        progressIndicator.setText2(string2);
                        progressIndicator.setFraction((double)this.myIndex / (double)n2);
                    }
                    ++this.myIndex;
                    for (String string2 : ((Map)map.get(virtualFile)).keySet()) {
                        PsiFile psiFile = baseFile.getViewProvider().getPsi((Language)string2);
                        if (psiFile == null || !psiFile.isValid()) continue;
                        for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                            duplocateVisitor.visitNode((PsiElement)psiFile);
                        }
                        InjectedLanguageManager.getInstance((Project)DuplicatesIndex.this.myProject).dropFileCaches(psiFile);
                    }
                }

                private static /* synthetic */ void J(int n22) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplicatesIndex$2", "visitFile"));
                }
            });
        }
        catch (IOException iOException) {
            LOG.error((Throwable)iOException);
        }
    }

    @Nullable
    private static IntSet J(@NotNull Map<VirtualFile, Map<Language, IntSet>> map, @NotNull PsiFragment psiFragment) {
        Map<Language, IntSet> map2;
        VirtualFile virtualFile;
        PsiFile psiFile;
        Language language;
        if (map == null) {
            DuplicatesIndex.J(5);
        }
        if (psiFragment == null) {
            DuplicatesIndex.J(6);
        }
        if ((language = psiFragment.getLanguage()) != null && (psiFile = psiFragment.getFile()) != null && (virtualFile = psiFile.getVirtualFile()) != null && (map2 = map.get(virtualFile)) != null) {
            return map2.get(language);
        }
        return null;
    }

    private Map<VirtualFile, Map<Language, IntSet>> J(@NotNull IntList intList) throws IOException {
        if (intList == null) {
            DuplicatesIndex.J(7);
        }
        Map map = CollectionFactory.createSmallMemoryFootprintMap();
        int n2 = intList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = intList.getInt(i2);
            List list = (List)this.myPersistentHashMap.get((Object)n3);
            if (list.size() < 2) continue;
            for (MyEntry myEntry : list) {
                IntSet intSet;
                VirtualFile virtualFile;
                Language language;
                if (myEntry.getTextRanges().length == 0 || (language = Language.findLanguageByID((String)myEntry.getLanguageId())) == null || (virtualFile = ManagingFS.getInstance().findFileById(myEntry.getFileId())) == null) continue;
                Map map2 = (Map)map.get(virtualFile);
                if (map2 == null) {
                    map2 = CollectionFactory.createSmallMemoryFootprintMap();
                    map.put(virtualFile, map2);
                }
                if ((intSet = (IntSet)map2.get(language)) == null) {
                    intSet = new IntOpenHashSet();
                    map2.put(language, intSet);
                }
                intSet.add(DuplicatesIndex.J(myEntry.getTextRanges()));
            }
        }
        map.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        return map;
    }

    private static int J(TextRange @NotNull [] textRangeArray) {
        if (textRangeArray == null) {
            DuplicatesIndex.J(8);
        }
        int n2 = 0;
        for (TextRange textRange : textRangeArray) {
            n2 = n2 * 31 + textRange.getStartOffset();
            n2 = n2 * 31 + textRange.getEndOffset();
        }
        return n2;
    }

    private static DuplocateVisitor[] J(DuplicatesProfile[] duplicatesProfileArray, FragmentsCollector fragmentsCollector) {
        DuplocateVisitor[] duplocateVisitorArray = new DuplocateVisitor[duplicatesProfileArray.length];
        for (int i2 = 0; i2 < duplocateVisitorArray.length; ++i2) {
            duplocateVisitorArray[i2] = duplicatesProfileArray[i2].createVisitor(fragmentsCollector);
        }
        return duplocateVisitorArray;
    }

    private static TextRange @NotNull [] J(@NotNull PsiFragment psiFragment) {
        if (psiFragment == null) {
            DuplicatesIndex.J(9);
        }
        PsiElement[] psiElementArray = psiFragment.getElements();
        ArrayList<TextRange> arrayList = new ArrayList<TextRange>(psiElementArray.length);
        for (PsiElement psiElement : psiElementArray) {
            arrayList.add(psiElement != null ? psiElement.getTextRange() : TextRange.EMPTY_RANGE);
        }
        TextRange[] textRangeArray = arrayList.toArray(TextRange.EMPTY_ARRAY);
        if (textRangeArray == null) {
            DuplicatesIndex.J(10);
        }
        return textRangeArray;
    }

    private static /* synthetic */ boolean J(IntList intList, Integer n2) {
        intList.add(n2.intValue());
        return true;
    }

    private static /* synthetic */ void J(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRanges";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentsSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextRanges";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }

    private static class MyDataExternalizer
    implements DataExternalizer<List<MyEntry>> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<MyEntry> entryList) throws IOException {
            if (out == null) {
                MyDataExternalizer.J(0);
            }
            out.writeInt(entryList.size());
            for (MyEntry myEntry : entryList) {
                out.writeInt(myEntry.getFileId());
                out.writeUTF(myEntry.getLanguageId());
                TextRange[] textRangeArray = myEntry.getTextRanges();
                out.writeInt(textRangeArray.length);
                for (TextRange textRange : textRangeArray) {
                    if (textRange == null) {
                        out.writeInt(0);
                        out.writeInt(0);
                        continue;
                    }
                    out.writeInt(textRange.getStartOffset());
                    out.writeInt(textRange.getEndOffset());
                }
            }
        }

        public List<MyEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyDataExternalizer.J(1);
            }
            int n2 = in.readInt();
            ArrayList<MyEntry> arrayList = new ArrayList<MyEntry>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = in.readInt();
                String string = in.readUTF();
                int n4 = in.readInt();
                TextRange[] textRangeArray = new TextRange[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = in.readInt();
                    int n6 = in.readInt();
                    textRangeArray[i3] = n5 == -1 || n6 == -1 ? null : new TextRange(n5, n6);
                }
                MyEntry myEntry = new MyEntry(n3, string, textRangeArray);
                arrayList.add(myEntry);
            }
            return arrayList;
        }

        private static /* synthetic */ void J(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyDataExternalizer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyIndexingFragmentsCollector
    implements FragmentsCollector {
        private final Int2ObjectMap<Set<MyEntry>> myMap = new Int2ObjectOpenHashMap();

        private MyIndexingFragmentsCollector() {
        }

        @NotNull
        public Int2ObjectMap<Set<MyEntry>> getResult() {
            Int2ObjectMap<Set<MyEntry>> int2ObjectMap = this.myMap;
            if (int2ObjectMap == null) {
                MyIndexingFragmentsCollector.J(0);
            }
            return int2ObjectMap;
        }

        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            if (frag == null) {
                return;
            }
            PsiFile psiFile = frag.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState((PsiFragment)frag);
            if (duplocatorState == null) {
                return;
            }
            int n2 = duplocatorState.getLowerBound();
            if (cost < n2 || cost > 7000) {
                return;
            }
            TextRange[] textRangeArray = DuplicatesIndex.J(frag);
            Language language = frag.getLanguage();
            if (language == null) {
                return;
            }
            HashSet<MyEntry> hashSet = (HashSet<MyEntry>)this.myMap.get(hash);
            if (hashSet == null) {
                hashSet = new HashSet<MyEntry>();
                this.myMap.put(hash, hashSet);
            }
            int n3 = FileBasedIndex.getFileId((VirtualFile)virtualFile);
            hashSet.add(new MyEntry(n3, language.getID(), textRangeArray));
        }

        private static /* synthetic */ void J(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesIndex$MyIndexingFragmentsCollector", "getResult"));
        }
    }

    private static class MyProcessingFragmentsCollector
    implements FragmentsCollector {
        private final Map<VirtualFile, Map<Language, IntSet>> myMap;
        private final FragmentsCollector myCollector;

        MyProcessingFragmentsCollector(Map<VirtualFile, Map<Language, IntSet>> map, FragmentsCollector collector) {
            this.myMap = map;
            this.myCollector = collector;
        }

        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState((PsiFragment)frag);
            if (duplocatorState == null) {
                return;
            }
            if (cost < duplocatorState.getLowerBound() || cost > 7000) {
                return;
            }
            IntSet intSet = DuplicatesIndex.J(this.myMap, frag);
            if (intSet != null) {
                boolean bl2 = false;
                TextRange[] textRangeArray = DuplicatesIndex.J(frag);
                int n2 = DuplicatesIndex.J(textRangeArray);
                if (intSet.contains(n2)) {
                    bl2 = true;
                }
                if (bl2) {
                    this.myCollector.add(hash, cost, frag);
                }
                return;
            }
            this.myCollector.add(hash, cost, frag);
        }
    }

    private static final class MyEntry {
        private final int myFileId;
        private final String myLanguageId;
        private final TextRange[] myTextRanges;

        private MyEntry(int fileId, @NotNull String languageId, TextRange @NotNull [] textRanges) {
            if (languageId == null) {
                MyEntry.J(0);
            }
            if (textRanges == null) {
                MyEntry.J(1);
            }
            this.myFileId = fileId;
            this.myLanguageId = languageId;
            this.myTextRanges = textRanges;
        }

        public int getFileId() {
            return this.myFileId;
        }

        @NotNull
        @NlsSafe
        public String getLanguageId() {
            String string = this.myLanguageId;
            if (string == null) {
                MyEntry.J(2);
            }
            return string;
        }

        public TextRange @NotNull [] getTextRanges() {
            if (this.myTextRanges == null) {
                MyEntry.J(3);
            }
            return this.myTextRanges;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            MyEntry myEntry = (MyEntry)o2;
            if (this.myFileId != myEntry.myFileId) {
                return false;
            }
            if (!this.myLanguageId.equals(myEntry.myLanguageId)) {
                return false;
            }
            return Arrays.equals(this.myTextRanges, myEntry.myTextRanges);
        }

        public int hashCode() {
            int n2 = this.myFileId;
            n2 = 31 * n2 + this.myLanguageId.hashCode();
            n2 = 31 * n2 + Arrays.hashCode(this.myTextRanges);
            return n2;
        }

        private static /* synthetic */ void J(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRanges";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRanges";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

