/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.graph.builder.GraphDataModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CachedGraphDataModel<N, E>
extends GraphDataModel<N, E> {
    private boolean myDirty = true;
    protected final Set<N> myNodes = new HashSet<N>();
    protected final Map<E, EdgeInfo<N>> myEdges = new HashMap<E, EdgeInfo<N>>();

    @Override
    @NotNull
    public Collection<N> getNodes() {
        this.checkUpdate();
        Set<N> set = this.myNodes;
        if (set == null) {
            CachedGraphDataModel.h(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<E> getEdges() {
        this.checkUpdate();
        Set<E> set = this.myEdges.keySet();
        if (set == null) {
            CachedGraphDataModel.h(1);
        }
        return set;
    }

    @Override
    @NotNull
    public N getSourceNode(E e10) {
        EdgeInfo<N> edgeInfo = this.myEdges.get(e10);
        Object n2 = edgeInfo.source;
        if (n2 == null) {
            CachedGraphDataModel.h(2);
        }
        return n2;
    }

    @Override
    @NotNull
    public N getTargetNode(E e10) {
        EdgeInfo<N> edgeInfo = this.myEdges.get(e10);
        Object n2 = edgeInfo.target;
        if (n2 == null) {
            CachedGraphDataModel.h(3);
        }
        return n2;
    }

    @Override
    public E createEdge(@NotNull N from, @NotNull N to) {
        if (from == null) {
            CachedGraphDataModel.h(4);
        }
        if (to == null) {
            CachedGraphDataModel.h(5);
        }
        return null;
    }

    public void dispose() {
    }

    protected void createNode(N node) {
        this.myNodes.add(node);
    }

    protected void createEdge(E edge, N source, N target) {
        this.myEdges.put(edge, new EdgeInfo<N>(source, target));
    }

    protected final synchronized void checkUpdate() {
        if (this.myDirty) {
            this.buildGraph();
            this.myDirty = false;
        }
    }

    protected abstract void buildGraph();

    protected void clear() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public final synchronized void setDirty() {
        this.myDirty = true;
    }

    private static /* synthetic */ void h(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/CachedGraphDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/CachedGraphDataModel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }

    protected static class EdgeInfo<N> {
        final N source;
        final N target;

        EdgeInfo(N source, N target) {
            this.source = source;
            this.target = target;
        }
    }
}

