/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.diagnostic.Checks;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.geom.YDimension;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphNodeRealizerService {
    @NotNull
    private static final Key<NodeCellRenderer> NODE_CELL_RENDERER_KEY = Key.create((String)"com.intellij.openapi.graph.services.GraphNodeRealizerService.NODE_CELL_RENDERER_KEY");
    @NotNull
    private static final GraphNodeRealizerService INSTANCE = new GraphNodeRealizerService();

    @NotNull
    public static GraphNodeRealizerService getInstance() {
        GraphNodeRealizerService graphNodeRealizerService = INSTANCE;
        if (graphNodeRealizerService == null) {
            GraphNodeRealizerService.J(0);
        }
        return graphNodeRealizerService;
    }

    private GraphNodeRealizerService() {
    }

    public boolean areRealizersEqual(@Nullable NodeRealizer a10, @Nullable NodeRealizer b10) {
        if (a10 == b10) {
            return true;
        }
        if (a10 == null || b10 == null || a10.getClass() != b10.getClass()) {
            return false;
        }
        return a10.getHeight() == b10.getHeight() && a10.getWidth() == b10.getWidth() && a10.getX() == b10.getX() && a10.getY() == b10.getY() && a10.isSelected() == b10.isSelected() && a10.isVisible() == b10.isVisible();
    }

    @Nullable
    public <T> T getUserData(@Nullable NodeRealizer nodeRealizer, @NotNull Key<T> dataKey) {
        Object object;
        if (dataKey == null) {
            GraphNodeRealizerService.J(1);
        }
        if (nodeRealizer instanceof GenericNodeRealizer && (object = ((GenericNodeRealizer)nodeRealizer).getUserData()) instanceof MyCloneableUserDataHolder) {
            return (T)((MyCloneableUserDataHolder)object).getCopyableUserData(dataKey);
        }
        return null;
    }

    public <T> void putUserData(@Nullable NodeRealizer nodeRealizer, @NotNull Key<T> dataKey, T data) {
        Object object;
        if (dataKey == null) {
            GraphNodeRealizerService.J(2);
        }
        if (nodeRealizer instanceof GenericNodeRealizer && (object = ((GenericNodeRealizer)nodeRealizer).getUserData()) instanceof MyCloneableUserDataHolder) {
            ((MyCloneableUserDataHolder)object).putCopyableUserData(dataKey, data);
            return;
        }
        Checks.fail((Object)("Given node realizer doesn't support user data: " + String.valueOf(nodeRealizer)));
    }

    private static void J(@NotNull GenericNodeRealizer genericNodeRealizer) {
        if (genericNodeRealizer == null) {
            GraphNodeRealizerService.J(3);
        }
        MyCloneableUserDataHolder myCloneableUserDataHolder = new MyCloneableUserDataHolder();
        genericNodeRealizer.setUserData(myCloneableUserDataHolder);
    }

    @Nullable
    public NodeCellRenderer getNodeCellRenderer(@Nullable NodeRealizer nodeRealizer) {
        return this.getUserData(nodeRealizer, NODE_CELL_RENDERER_KEY);
    }

    @NotNull
    public GenericNodeRealizer createGenericNodeRealizer(@NotNull @NonNls String configurationKey, @NotNull NodeCellRenderer nodeCellRenderer) {
        if (configurationKey == null) {
            GraphNodeRealizerService.J(4);
        }
        if (nodeCellRenderer == null) {
            GraphNodeRealizerService.J(5);
        }
        GraphNodeRealizerService.J(configurationKey, nodeCellRenderer);
        GenericNodeRealizer genericNodeRealizer = GraphManager.getGraphManager().createGenericNodeRealizer(configurationKey);
        GraphNodeRealizerService.J(genericNodeRealizer);
        this.putUserData(genericNodeRealizer, NODE_CELL_RENDERER_KEY, nodeCellRenderer);
        GenericNodeRealizer genericNodeRealizer2 = genericNodeRealizer;
        if (genericNodeRealizer2 == null) {
            GraphNodeRealizerService.J(6);
        }
        return genericNodeRealizer2;
    }

    private static void J(@NotNull @NonNls String string, @NotNull NodeCellRenderer nodeCellRenderer) {
        if (string == null) {
            GraphNodeRealizerService.J(7);
        }
        if (nodeCellRenderer == null) {
            GraphNodeRealizerService.J(8);
        }
        GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
        Map map = factory.createDefaultConfigurationMap();
        map.put(GenericNodeRealizer.Painter.class, GraphManager.getGraphManager().createFastNodeCellRendererPainter(nodeCellRenderer, NodeCellRendererPainter.USER_DATA_MAP));
        map.put(GenericNodeRealizer.UserDataHandler.class, new MyUserDataHandler());
        map.put(GenericNodeRealizer.GenericSizeConstraintProvider.class, new MySizeConstraintProvider());
        factory.addConfiguration(string, map);
    }

    private static /* synthetic */ void J(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphNodeRealizerService";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRealizer";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKey";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCellRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphNodeRealizerService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenericNodeRealizer";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupUserDataHolderFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGenericNodeRealizer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "associateDefaultRealizerConfigsWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyCloneableUserDataHolder
    extends UserDataHolderBase
    implements Cloneable {
        private MyCloneableUserDataHolder() {
        }

        public MyCloneableUserDataHolder clone() {
            return (MyCloneableUserDataHolder)super.clone();
        }
    }

    private static final class MyUserDataHandler
    implements GenericNodeRealizer.UserDataHandler {
        private MyUserDataHandler() {
        }

        @Override
        public void storeUserData(NodeRealizer _nodeRealizer, Object _o, ObjectOutputStream _objectOutputStream) throws IOException {
        }

        @Override
        @Nullable
        public Object readUserData(NodeRealizer _nodeRealizer, ObjectInputStream _objectInputStream) throws IOException {
            return null;
        }

        @Override
        @Nullable
        public Object copyUserData(NodeRealizer source, Object userData, NodeRealizer dest) {
            Object object;
            if (source instanceof GenericNodeRealizer && (object = ((GenericNodeRealizer)source).getUserData()) instanceof MyCloneableUserDataHolder) {
                return ((MyCloneableUserDataHolder)object).clone();
            }
            return null;
        }
    }

    private static final class MySizeConstraintProvider
    implements GenericNodeRealizer.GenericSizeConstraintProvider {
        private MySizeConstraintProvider() {
        }

        @Override
        public YDimension getMinimumSize(NodeRealizer realizer) {
            return Optional.ofNullable(MySizeConstraintProvider.J(realizer)).map(jComponent -> MySizeConstraintProvider.J(jComponent.getMinimumSize())).orElseGet(() -> GraphManager.getGraphManager().createYDimension(0.0, 0.0));
        }

        @Override
        public YDimension getMaximumSize(NodeRealizer realizer) {
            return Optional.ofNullable(MySizeConstraintProvider.J(realizer)).map(jComponent -> MySizeConstraintProvider.J(jComponent.getMaximumSize())).orElseGet(() -> GraphManager.getGraphManager().createYDimension(2.147483647E9, 2.147483647E9));
        }

        @Nullable
        private static JComponent J(NodeRealizer nodeRealizer) {
            NodeCellRenderer nodeCellRenderer = GraphNodeRealizerService.getInstance().getNodeCellRenderer(nodeRealizer);
            if (nodeCellRenderer != null) {
                return nodeCellRenderer.getNodeCellRendererComponent((Graph2DView)((Graph2D)nodeRealizer.getNode().getGraph()).getCurrentView(), nodeRealizer, null, nodeRealizer.isSelected());
            }
            return null;
        }

        @NotNull
        private static YDimension J(@NotNull Dimension dimension) {
            if (dimension == null) {
                MySizeConstraintProvider.J(0);
            }
            YDimension yDimension = GraphManager.getGraphManager().createYDimension(dimension.getWidth(), dimension.getHeight());
            if (yDimension == null) {
                MySizeConstraintProvider.J(1);
            }
            return yDimension;
        }

        private static /* synthetic */ void J(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dimension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/services/GraphNodeRealizerService$MySizeConstraintProvider";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/services/GraphNodeRealizerService$MySizeConstraintProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapToYDimension";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapToYDimension";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

