/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.base.Command;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2DUndoManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface GraphUndoService {
    @NotNull
    public static GraphUndoService getInstance() {
        GraphUndoService graphUndoService = (GraphUndoService)ApplicationManager.getApplication().getService(GraphUndoService.class);
        if (graphUndoService == null) {
            GraphUndoService.J(0);
        }
        return graphUndoService;
    }

    @NotNull
    public Graph2DUndoManager setupUndoManagerFor(@NotNull GraphBuilder<?, ?> var1);

    @RequiresEdt
    public void performPositionsOnlyChangingAction(@NotNull GraphBuilder<?, ?> var1, @NotNull @Nls String var2, @NotNull BiConsumer<? super Runnable, ? super Runnable> var3, @NotNull Consumer<? super Runnable> var4, @NotNull Consumer<? super Runnable> var5);

    @RequiresEdt
    default public void performPositionsOnlyChangingAction(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String commandName, @NotNull Runnable action, @NotNull Consumer<? super Runnable> onUndo, @NotNull Consumer<? super Runnable> onRedo) {
        if (builder == null) {
            GraphUndoService.J(1);
        }
        if (commandName == null) {
            GraphUndoService.J(2);
        }
        if (action == null) {
            GraphUndoService.J(3);
        }
        if (onUndo == null) {
            GraphUndoService.J(4);
        }
        if (onRedo == null) {
            GraphUndoService.J(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.performPositionsOnlyChangingAction(builder, commandName, (? super Runnable runnable2, ? super Runnable runnable3) -> {
            runnable2.run();
            action.run();
            runnable3.run();
        }, onUndo, onRedo);
    }

    @RequiresEdt
    default public void performPositionsOnlyChangingAction(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String commandName, @NotNull Runnable action) {
        if (builder == null) {
            GraphUndoService.J(6);
        }
        if (commandName == null) {
            GraphUndoService.J(7);
        }
        if (action == null) {
            GraphUndoService.J(8);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.performPositionsOnlyChangingAction(builder, commandName, action, (? super Runnable runnable) -> runnable.run(), (? super Runnable runnable) -> runnable.run());
    }

    @RequiresWriteLock
    default public void performUndoableAction(@NotNull GraphBuilder<?, ?> builder, @NotNull Command command) {
        if (builder == null) {
            GraphUndoService.J(9);
        }
        if (command == null) {
            GraphUndoService.J(10);
        }
        ThreadingAssertions.assertWriteAccess();
        command.execute();
        this.undoableActionPerformed(builder, command);
    }

    @RequiresWriteLock
    default public void undoableActionPerformed(@NotNull GraphBuilder<?, ?> builder, @NotNull Command command) {
        if (builder == null) {
            GraphUndoService.J(11);
        }
        if (command == null) {
            GraphUndoService.J(12);
        }
        ThreadingAssertions.assertWriteAccess();
        builder.getUndoManager().push(command);
    }

    @ApiStatus.Internal
    @NotNull
    public Pair<Runnable, Runnable> backupRealizers(@NotNull GraphBuilder<?, ?> var1, @NotNull NodeCursor var2, @NotNull EdgeCursor var3, @NotNull Consumer<? super Runnable> var4, @NotNull Consumer<? super Runnable> var5);

    private static /* synthetic */ void J(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphUndoService";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUndo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRedo";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphUndoService";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performPositionsOnlyChangingAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performUndoableAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "undoableActionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

