/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view.hierarchy;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.GraphFactory;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.view.hierarchy.HierarchyListener;
import com.intellij.openapi.graph.view.hierarchy.InterEdgeConfigurator;
import java.util.Iterator;

public interface HierarchyManager {
    public void dispose();

    public Node createFolderNode(Node var1);

    public Node createFolderNode(Graph var1);

    public void removeFolderNode(Node var1);

    public Node createGroupNode(Node var1);

    public void removeGroupNode(Node var1);

    public Node createGroupNode(Graph var1);

    public void convertToGroupNode(Node var1);

    public Edge createEdge(Node var1, Node var2);

    public void changeEdge(Edge var1, Node var2, Node var3);

    public void reInsertEdge(Edge var1, Node var2, Node var3);

    public Node getRepresentative(Node var1, Graph var2);

    public void convertToFolderNode(Node var1);

    public void convertToFolderNode(Node var1, Graph var2);

    public void closeGroup(Node var1);

    public void openFolder(Node var1);

    public void convertToNormalNode(Node var1);

    public void convertToInterEdge(Edge var1, Node var2, Node var3);

    public void convertToNormalEdge(Edge var1);

    public GraphFactory getGraphFactory();

    public void setGraphFactory(GraphFactory var1);

    public InterEdgeConfigurator getInterEdgeConfigurator();

    public void setInterEdgeConfigurator(InterEdgeConfigurator var1);

    public void preTraverse(NodeVisitor var1);

    public void preTraverse(Node var1, NodeVisitor var2);

    public void postTraverse(NodeVisitor var1);

    public void postTraverse(Node var1, NodeVisitor var2);

    public Iterator preTraversal();

    public Iterator preTraversal(Node var1);

    public Iterator postTraversal();

    public Iterator postTraversal(Node var1);

    public DataProvider getNodeIdDataProvider();

    public DataProvider getParentNodeIdDataProvider();

    public DataProvider getGroupNodeDataProvider();

    public Node getRealSource(Edge var1);

    public Node getRealTarget(Edge var1);

    public boolean contains(Graph var1);

    public InterEdgeData getInterEdgeData(Edge var1);

    public boolean isInterEdge(Edge var1);

    public boolean isFolderNode(Node var1);

    public boolean isGroupNode(Node var1);

    public boolean isNormalNode(Node var1);

    public boolean containsGroups();

    public Graph getInnerGraph(Node var1);

    public Node getAnchorNode(Graph var1);

    public Node getParentNode(Node var1);

    public boolean isAncestor(Node var1, Node var2);

    public Graph getParentGraph(Graph var1);

    public Graph getRootGraph();

    public boolean isRootGraph(Graph var1);

    public Object[] getFolderPath(Object var1);

    public Object[] getTreePath(Object var1);

    public Object[] getTreePath(Object var1, boolean var2);

    public Node getNearestCommonAncestor(NodeList var1);

    public Graph getNearestCommonAncestor(Graph var1, Graph var2);

    public NodeList getFolderNodes(Graph var1, boolean var2);

    public int getLocalGroupDepth(Node var1);

    public NodeCursor getChildren(Node var1);

    public void addHierarchyListener(HierarchyListener var1);

    public void removeHierarchyListener(HierarchyListener var1);

    public Iterator getHierarchyListeners();

    public void moveToFirst(Node var1);

    public void moveToLast(Node var1);

    public void foldSubgraph(NodeList var1, Node var2);

    public void unfoldSubgraph(Graph var1, NodeList var2);

    public void setParentNode(NodeList var1, Node var2);

    public void setParentNode(Node var1, Node var2);

    public void groupSubgraph(NodeList var1, Node var2);

    public void ungroupSubgraph(NodeList var1);

    public static class Statics {
        public static HierarchyManager getInstance(Graph graph) {
            return GraphManager.getGraphManager()._HierarchyManager_getInstance(graph);
        }

        public static boolean containsGroupNodes(Graph graph) {
            return GraphManager.getGraphManager()._HierarchyManager_containsGroupNodes(graph);
        }

        public static boolean isReorderingEnabled() {
            return GraphManager.getGraphManager()._HierarchyManager_isReorderingEnabled();
        }

        public static void setReorderingEnabled(boolean b10) {
            GraphManager.getGraphManager()._HierarchyManager_setReorderingEnabled(b10);
        }
    }

    public static interface NodeVisitor {
        public void visitNode(Node var1);
    }

    public static interface InterEdgeData {
        public static final String SOURCE_PORT_KEY = GraphManager.getGraphManager()._InterEdgeData_SOURCE_PORT_KEY();
        public static final String TARGET_PORT_KEY = GraphManager.getGraphManager()._InterEdgeData_TARGET_PORT_KEY();

        public Node getRealSource();

        public Node getRealTarget();

        public Object get(String var1);

        public Object remove(String var1);

        public Object put(String var1, Object var2);
    }
}

