/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.inlayHint;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspInlayHintCustomizer;
import com.intellij.platform.lsp.api.customization.LspInlayHintSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.highlightingCommon.LspCachedHighlighting;
import com.intellij.platform.lsp.impl.inlayHint.LspInlayHintsProviderKt;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006."}, d2={"Lcom/intellij/platform/lsp/impl/inlayHint/LspInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "Lcom/intellij/openapi/project/DumbAware;", "LspInlayHintsProvider", "()V", "isVisibleInSettings", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "createSettings", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "J", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "project", "Lcom/intellij/openapi/project/Project;", "inlayHint", "Lorg/eclipse/lsp4j/InlayHint;", "maxChars", "", "J", "", "targetUri", "targetRange", "Lorg/eclipse/lsp4j/Range;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspInlayHintsProvider.kt\ncom/intellij/platform/lsp/impl/inlayHint/LspInlayHintsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1391#2:153\n1480#2,2:154\n777#2:156\n873#2,2:157\n1586#2:159\n1661#2,3:160\n1482#2,3:163\n*S KotlinDebug\n*F\n+ 1 LspInlayHintsProvider.kt\ncom/intellij/platform/lsp/impl/inlayHint/LspInlayHintsProvider\n*L\n56#1:153\n56#1:154,2\n62#1:156\n62#1:157,2\n63#1:159\n63#1:160,3\n56#1:163,3\n*E\n"})
public final class LspInlayHintsProvider
implements InlayHintsProvider<NoSettings>,
DumbAware {
    private final boolean isVisibleInSettings;
    @NotNull
    private final String name;
    @NotNull
    private final SettingsKey<NoSettings> key = LspInlayHintsProviderKt.access$getLspInlayHintsKey$p();
    @Nullable
    private final String previewText;

    public LspInlayHintsProvider() {
        this.name = "LSP-based inlay hints";
    }

    public boolean isVisibleInSettings() {
        return this.isVisibleInSettings;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return this.key;
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            public JComponent createComponent(ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return new JPanel();
            }
        };
    }

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 instanceof VirtualFileWindow || !virtualFile2.isInLocalFileSystem()) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Collection<LspServerImpl> collection = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
        Iterable iterable = collection;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList();
        boolean bl3 = false;
        for (Object t2 : iterable2) {
            List list;
            Object object = (LspServerImpl)t2;
            boolean bl4 = false;
            LspInlayHintCustomizer lspInlayHintCustomizer = ((LspServerImpl)object).getDescriptor().getLspCustomization().getInlayHintCustomizer();
            if (lspInlayHintCustomizer instanceof LspInlayHintSupport) {
                boolean bl5;
                LspCachedHighlighting lspCachedHighlighting;
                int n2 = ((LspInlayHintSupport)lspInlayHintCustomizer).getMaxInlayHintChars();
                int n3 = RangesKt.coerceIn((int)n2, (int)1, (int)100);
                Iterable iterable3 = ((LspServerImpl)object).getInlayHints$intellij_platform_lsp_impl(virtualFile2);
                boolean bl6 = false;
                Iterable iterable4 = iterable3;
                Collection collection3 = new ArrayList();
                boolean bl7 = false;
                for (Object t3 : iterable4) {
                    lspCachedHighlighting = (LspCachedHighlighting)t3;
                    bl5 = false;
                    if (!((LspInlayHintSupport)lspInlayHintCustomizer).shouldApplyInlayHint((InlayHint)lspCachedHighlighting.getHighlightingInfo())) continue;
                    collection3.add(t3);
                }
                iterable3 = (List)collection3;
                bl6 = false;
                iterable4 = iterable3;
                collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
                bl7 = false;
                for (Object t3 : iterable4) {
                    lspCachedHighlighting = (LspCachedHighlighting)t3;
                    Collection collection4 = collection3;
                    bl5 = false;
                    collection4.add(TuplesKt.to((Object)lspCachedHighlighting, (Object)n3));
                }
                list = (List)collection3;
            } else {
                list = CollectionsKt.emptyList();
            }
            object = list;
            CollectionsKt.addAll((Collection)collection2, (Iterable)object);
        }
        List list = (List)collection2;
        if (list.isEmpty()) {
            return null;
        }
        return new InlayHintsCollector(file, list, this){
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ List<Pair<LspCachedHighlighting<InlayHint>, Integer>> $inlayHints;
            final /* synthetic */ LspInlayHintsProvider this$0;
            {
                this.$file = $file;
                this.$inlayHints = $inlayHints;
                this.this$0 = $receiver;
            }

            public boolean collect(PsiElement element, Editor editor, InlayHintsSink sink) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                if (element != this.$file) {
                    return true;
                }
                for (Pair<LspCachedHighlighting<InlayHint>, Integer> pair : this.$inlayHints) {
                    LspCachedHighlighting lspCachedHighlighting = (LspCachedHighlighting)pair.component1();
                    int n2 = ((Number)pair.component2()).intValue();
                    PresentationFactory presentationFactory = new PresentationFactory(editor);
                    Project project = this.$file.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    InlayPresentation inlayPresentation = LspInlayHintsProvider.access$buildPresentation(this.this$0, presentationFactory, project, (InlayHint)lspCachedHighlighting.getHighlightingInfo(), n2);
                    InlayPresentation inlayPresentation2 = presentationFactory.roundWithBackground(inlayPresentation);
                    sink.addInlineElement(lspCachedHighlighting.getTextRange().getStartOffset(), false, inlayPresentation2, false);
                }
                return true;
            }
        };
    }

    private final InlayPresentation J(PresentationFactory presentationFactory, Project project, InlayHint inlayHint, int n2) {
        String string;
        Either either = inlayHint.getLabel();
        String string2 = "...";
        List list = (List)either.getRight();
        if (list != null) {
            Cursor cursor = Cursor.getPredefinedCursor(12);
            List list2 = new ArrayList();
            int n3 = 0;
            for (InlayHintLabelPart inlayHintLabelPart : list) {
                String string3 = inlayHintLabelPart.getValue();
                if ((n3 += string3.length()) > n2) {
                    ((Collection)list2).add(presentationFactory.smallText(string2));
                    break;
                }
                Intrinsics.checkNotNull((Object)string3);
                InlayPresentation inlayPresentation = presentationFactory.smallText(string3);
                Location location = inlayHintLabelPart.getLocation();
                if (location != null) {
                    InlayPresentation inlayPresentation2 = presentationFactory.reference(inlayPresentation, () -> LspInlayHintsProvider.J(this, project, location));
                    Intrinsics.checkNotNull((Object)cursor);
                    inlayPresentation = presentationFactory.withCursorOnHoverWhenControlDown(inlayPresentation2, cursor);
                }
                ((Collection)list2).add(inlayPresentation);
            }
            return (InlayPresentation)new SequencePresentation(list2);
        }
        String string4 = (String)either.getLeft();
        if (string4 == null) {
            string4 = "";
        }
        String string5 = (string = string4).length() > n2 ? StringsKt.take((String)string, (int)n2) + string2 : string;
        return presentationFactory.smallText(string5);
    }

    private final void J(Project project, String string, Range range) {
        Collection<LspServerImpl> collection = LspServerManagerImpl.Companion.getInstanceImpl(project).getAllRunningServers$intellij_platform_lsp_impl();
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> LspInlayHintsProvider.J(string, arg_0)));
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile2), true);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (range != null) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            Position position = range.getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
            Integer n2 = Lsp4jUtilKt.getOffsetInDocument(document2, position);
            if (n2 == null) {
                return;
            }
            int n3 = n2;
            editor2.getCaretModel().moveToOffset(n3);
        }
    }

    private static final Unit J(LspInlayHintsProvider lspInlayHintsProvider, Project project, Location location) {
        String string = location.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        lspInlayHintsProvider.J(project, string, location.getRange());
        return Unit.INSTANCE;
    }

    private static final VirtualFile J(String string, LspServerImpl lspServerImpl) {
        Intrinsics.checkNotNullParameter((Object)lspServerImpl, (String)"server");
        return lspServerImpl.getDescriptor().findFileByUri(string);
    }

    public static final /* synthetic */ InlayPresentation access$buildPresentation(LspInlayHintsProvider $this, PresentationFactory factory, Project project, InlayHint inlayHint, int maxChars) {
        return $this.J(factory, project, inlayHint, maxChars);
    }
}

