/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.index;

import com.intellij.ide.projectView.impl.FileNestingBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.languagescope.DuplicateScopeExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0003\u00a8\u0006\n"}, d2={"isIndexed", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "J", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "J", "J", "intellij.platform.duplicatesDetector"})
public final class HashIndexFileFilterKt {
    public static final boolean isIndexed(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        DuplicateScope duplicateScope = DuplicateScopeExtension.Companion.findDuplicateScope(fileType);
        if (duplicateScope == null) {
            return false;
        }
        DuplicateScope duplicateScope2 = duplicateScope;
        return HashIndexFileFilterKt.J(duplicateScope2, project, file) && ProjectFileIndex.getInstance((Project)project).isInContent(file) && !HashIndexFileFilterKt.J(file) && file.getLength() < (long)Registry.Companion.intValue("duplicates.index.file.maxSize") && HashIndexFileFilterKt.J(project, file) && !FileNestingBuilder.getInstance().isNestedFile(project, file);
    }

    private static final boolean J(DuplicateScope duplicateScope, Project project, VirtualFile virtualFile) {
        return duplicateScope.getIndexConfiguration().isEnabled() && duplicateScope.acceptsFile(project, virtualFile);
    }

    private static final boolean J(Project project, VirtualFile virtualFile) {
        return ProjectFileIndex.getInstance((Project)project).isInTestSourceContent(virtualFile) ? Registry.Companion.is("duplicates.index.file.test.enable") : true;
    }

    @NonNls
    private static final boolean J(VirtualFile virtualFile) {
        return VfsUtilCore.findContainingDirectory((VirtualFile)virtualFile, (CharSequence)"generated") != null;
    }
}

