/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.actions.edit.mode.vertical;

import com.intellij.jupyter.core.editor.actions.edit.mode.JupyterCaretMoveHandler;
import com.intellij.jupyter.core.editor.actions.edit.mode.JupyterCustomCaretMoveUtilKt;
import com.intellij.jupyter.core.editor.actions.edit.mode.VerticalDirection;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J,\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/editor/actions/edit/mode/vertical/VerticalCaretMove;", "Lcom/intellij/jupyter/core/editor/actions/edit/mode/JupyterCaretMoveHandler;", "direction", "Lcom/intellij/jupyter/core/editor/actions/edit/mode/VerticalDirection;", "<init>", "(Lcom/intellij/jupyter/core/editor/actions/edit/mode/VerticalDirection;)V", "tryMove", "", "jupyterEditor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "handleJupyterLabStyle", "editor", "intellij.jupyter.core"})
public final class VerticalCaretMove
implements JupyterCaretMoveHandler {
    @NotNull
    private final VerticalDirection direction;

    public VerticalCaretMove(@NotNull VerticalDirection direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
    }

    @Override
    public void tryMove(@NotNull Editor jupyterEditor, @NotNull Caret caret, @Nullable DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditor, (String)"jupyterEditor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (!JupyterSettings.Companion.getInstance().getUseJupyterLabStyleNavigation()) {
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(jupyterEditor, caret, dataContext);
            }
            return;
        }
        if (!JupyterCustomCaretMoveUtilKt.isAtVisibleCellBorderLine(jupyterEditor, caret, this.direction)) {
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(jupyterEditor, caret, dataContext);
            }
            return;
        }
        this.handleJupyterLabStyle(jupyterEditor, caret, dataContext, originalHandler);
    }

    private final void handleJupyterLabStyle(Editor editor, Caret caret, DataContext dataContext, EditorActionHandler originalHandler) {
        if (JupyterCustomCaretMoveUtilKt.isAtVisibleCellBorder(editor, caret, this.direction)) {
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(editor, caret, dataContext);
            }
        } else {
            JupyterCustomCaretMoveUtilKt.moveCaretToVisualCellBorder(editor, caret, this.direction, false);
        }
    }
}

