/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.ui;

import com.intellij.codeInsight.template.CaretAutoMoveController;
import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.editor.NewJupyterEditorSwitch;
import com.intellij.jupyter.core.editor.ui.CellLinedModificationStamp;
import com.intellij.jupyter.core.editor.ui.NotebookCellMarkerDecoratorKt;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesLexer;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorLastActionTracker;
import com.intellij.util.ui.EDT;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u0015\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "cellLinesModificationStamp", "Lcom/intellij/jupyter/core/editor/ui/CellLinedModificationStamp;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "protectMarkers", "document", "Lcom/intellij/openapi/editor/Document;", "isWholeTextReplaced", "", "updateGuardedBlocks", "markers", "", "Lcom/intellij/notebooks/visualization/NotebookCellLinesLexer$Marker;", "updateFolding", "Factory", "NotebookCaretListener", "NotebookKeyAdapter", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellMarkerDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellMarkerDecorator.kt\ncom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n296#2,2:221\n1915#2,2:223\n1915#2,2:225\n1#3:227\n*S KotlinDebug\n*F\n+ 1 NotebookCellMarkerDecorator.kt\ncom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator\n*L\n103#1:221,2\n111#1:223,2\n148#1:225,2\n*E\n"})
public final class NotebookCellMarkerDecorator
implements DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private CellLinedModificationStamp cellLinesModificationStamp;

    private NotebookCellMarkerDecorator(Editor editor) {
        this.editor = editor;
        this.cellLinesModificationStamp = new CellLinedModificationStamp(this.editor, null);
        this.editor.getDocument().putUserData(DocumentImpl.IGNORE_RANGE_GUARDS_ON_FULL_UPDATE, (Object)true);
        ActionsKt.runInEdt$default(null, () -> NotebookCellMarkerDecorator._init_$lambda$0(this), (int)1, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.editor.getDocument(), NotebookCellMarkerDecorator::_init_$lambda$1);
        this.editor.getColorsScheme().setColor(ColorKey.find((String)"READONLY_FRAGMENT_BACKGROUND"), null);
        this.editor.getCaretModel().addCaretListener((CaretListener)new NotebookCaretListener());
        this.editor.getContentComponent().addKeyListener(new NotebookKeyAdapter());
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.protectMarkers(document, event.isWholeTextReplaced());
    }

    private final void protectMarkers(Document document, boolean isWholeTextReplaced) {
        if (NewJupyterEditorSwitch.isHeaderEditingAllowed()) {
            return;
        }
        EDT.assertIsEdt();
        for (Editor editor : EditorFactory.getInstance().editors(document).toList()) {
            if (editor.isDisposed()) continue;
            Intrinsics.checkNotNull((Object)editor);
            this.protectMarkers(document, editor, isWholeTextReplaced);
        }
    }

    static /* synthetic */ void protectMarkers$default(NotebookCellMarkerDecorator notebookCellMarkerDecorator, Document document, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        notebookCellMarkerDecorator.protectMarkers(document, bl);
    }

    private final void protectMarkers(Document document, Editor editor, boolean isWholeTextReplaced) {
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor);
        CellLinedModificationStamp previousStamp = this.cellLinesModificationStamp;
        this.cellLinesModificationStamp = new CellLinedModificationStamp(editor, cellLines.getModificationStamp());
        if (!isWholeTextReplaced && Intrinsics.areEqual((Object)previousStamp, (Object)this.cellLinesModificationStamp)) {
            return;
        }
        List markers = NotebookVisualizationUiUtilKt.makeMarkersFromIntervals((Document)document, (Iterable)cellLines.getIntervals());
        this.updateGuardedBlocks(document, markers);
        this.updateFolding(markers, editor);
    }

    private final void updateGuardedBlocks(Document document, List<NotebookCellLinesLexer.Marker> markers) {
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
        List list = ((DocumentEx)document).getGuardedBlocks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGuardedBlocks(...)");
        Set oldMarkers = CollectionsKt.toMutableSet((Iterable)list);
        for (NotebookCellLinesLexer.Marker marker : markers) {
            Object v1;
            Iterable $this$firstOrNull$iv;
            int end;
            int start2;
            block4: {
                start2 = marker.getOffset() > 0 ? marker.getOffset() - 1 : marker.getOffset();
                end = marker.getOffset() + marker.getLength();
                $this$firstOrNull$iv = oldMarkers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RangeMarker it = (RangeMarker)element$iv;
                    boolean bl = false;
                    if (!(it.getStartOffset() == start2 && it.getEndOffset() == end)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            RangeMarker old = v1;
            if (old != null) {
                oldMarkers.remove(old);
                continue;
            }
            $this$firstOrNull$iv = document.createGuardedBlock(start2, end);
            Intrinsics.checkNotNull((Object)$this$firstOrNull$iv);
        }
        Iterable $this$forEach$iv = oldMarkers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeMarker it = (RangeMarker)element$iv;
            boolean bl = false;
            document.removeGuardedBlock(it);
        }
    }

    private final void updateFolding(List<NotebookCellLinesLexer.Marker> markers, Editor editor) {
        Map markerAtOffset = new LinkedHashMap();
        for (NotebookCellLinesLexer.Marker marker : markers) {
            markerAtOffset.put(marker.getOffset(), marker);
        }
        Set markersToAdd = CollectionsKt.toMutableSet((Iterable)markers);
        List regionsToRemove = new ArrayList();
        FoldingModel foldingModel = editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.FoldingModelEx");
        FoldingModelEx foldingModel2 = (FoldingModelEx)foldingModel;
        FoldRegion[] foldRegionArray = foldingModel2.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        for (FoldRegion foldRegion : foldRegionArray) {
            boolean isStillValid;
            Intrinsics.checkNotNull((Object)foldRegion);
            FoldRegion region2 = foldRegion;
            if (!Intrinsics.areEqual((Object)region2.getUserData(NotebookCellMarkerDecoratorKt.access$getRegionKey$p()), (Object)true)) continue;
            NotebookCellLinesLexer.Marker marker = (NotebookCellLinesLexer.Marker)markerAtOffset.get(region2.getStartOffset());
            boolean bl = isStillValid = marker != null && region2.getStartOffset() == marker.getOffset() && region2.getEndOffset() == marker.getOffset() + marker.getLength();
            if (isStillValid) {
                markersToAdd.remove(marker);
                continue;
            }
            regionsToRemove.add(region2);
        }
        if (markersToAdd.isEmpty() && regionsToRemove.isEmpty()) {
            return;
        }
        if (NotebookUtil.INSTANCE.isDiffKind(editor)) {
            return;
        }
        foldingModel2.runBatchFoldingOperation(() -> NotebookCellMarkerDecorator.updateFolding$lambda$0(regionsToRemove, markersToAdd, foldingModel2), true, false);
    }

    private static final Unit _init_$lambda$0(NotebookCellMarkerDecorator this$0) {
        Document document = this$0.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        NotebookCellMarkerDecorator.protectMarkers$default(this$0, document, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(ReadOnlyFragmentModificationException it) {
    }

    private static final void updateFolding$lambda$0(List $regionsToRemove, Set $markersToAdd, FoldingModelEx $foldingModel) {
        Iterable $this$forEach$iv = $regionsToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion it = (FoldRegion)element$iv;
            boolean bl = false;
            $foldingModel.removeFoldRegion(it);
        }
        for (NotebookCellLinesLexer.Marker marker : $markersToAdd) {
            FoldRegion foldRegion;
            int startOffset = marker.getOffset();
            NotebookCellLinesLexer.Marker $this$updateFolding_u24lambda_u240_u241 = marker;
            boolean bl = false;
            int endOffset = $this$updateFolding_u24lambda_u240_u241.getOffset() + $this$updateFolding_u24lambda_u240_u241.getLength();
            if ($foldingModel.createFoldRegion(startOffset, endOffset, "", null, true) == null) continue;
            FoldRegion $this$updateFolding_u24lambda_u240_u242 = foldRegion;
            boolean bl2 = false;
            $this$updateFolding_u24lambda_u240_u242.putUserData(NotebookCellMarkerDecoratorKt.access$getRegionKey$p(), (Object)true);
            $this$updateFolding_u24lambda_u240_u242.putUserData(CustomFoldRegion.IMMUTABLE_FOLD_REGION, (Object)true);
        }
    }

    @JvmStatic
    public static final void attach(@NotNull Editor editor) {
        Companion.attach(editor);
    }

    public /* synthetic */ NotebookCellMarkerDecorator(Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$Companion;", "", "<init>", "()V", "attach", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nNotebookCellMarkerDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellMarkerDecorator.kt\ncom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n42#2,3:221\n1#3:224\n*S KotlinDebug\n*F\n+ 1 NotebookCellMarkerDecorator.kt\ncom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$Companion\n*L\n217#1:221,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void attach(@NotNull Editor editor) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                boolean $i$f$service = false;
                Class<Factory> serviceClass$iv = Factory.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                DocumentListener documentListener = ((Factory)object).create(editor);
                if (documentListener == null) break block1;
                DocumentListener it = documentListener;
                boolean bl = false;
                NotebookVisualizationUiUtilKt.addEditorDocumentListener((Editor)editor, (DocumentListener)it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0006J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$Factory;", "", "create", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Production", "intellij.jupyter.core"})
    public static interface Factory {
        @Nullable
        public DocumentListener create(@NotNull Editor var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$Factory$Production;", "Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$Factory;", "<init>", "()V", "create", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
        public static final class Production
        implements Factory {
            @Override
            @NotNull
            public DocumentListener create(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return new NotebookCellMarkerDecorator(editor, null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$NotebookCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "()V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "EXEMPTED_ACTIONS", "", "", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nNotebookCellMarkerDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellMarkerDecorator.kt\ncom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$NotebookCaretListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,220:1\n13#2:221\n*S KotlinDebug\n*F\n+ 1 NotebookCellMarkerDecorator.kt\ncom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$NotebookCaretListener\n*L\n180#1:221\n*E\n"})
    private static final class NotebookCaretListener
    implements CaretListener {
        @NotNull
        private final List<String> EXEMPTED_ACTIONS;

        public NotebookCaretListener() {
            Object[] objectArray = new String[]{"NewScratchFile", "EditorPreviousWord", "EditorLeft", "EditorDeleteToWordStart", "EditorUp", "EditorLineStart", "Undo"};
            this.EXEMPTED_ACTIONS = CollectionsKt.listOf((Object[])objectArray);
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            boolean canMove;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Caret caret = event.getCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCaret(...)");
            Caret caret2 = caret;
            int offset = caret2.getOffset();
            String lastAction = EditorLastActionTracker.getInstance().getLastActionId();
            FoldRegion foldRegion = caret2.getEditor().getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion == null) {
                return;
            }
            FoldRegion region2 = foldRegion;
            if (region2.isExpanded() || !region2.shouldNeverExpand() || !NotebookCellMarkerDecoratorKt.isCellMarker(region2)) {
                return;
            }
            boolean bl = canMove = (offset == 0 || CollectionsKt.contains((Iterable)this.EXEMPTED_ACTIONS, (Object)lastAction)) && CaretAutoMoveController.isCaretMovementAllowed((Editor)event.getEditor());
            if (canMove) {
                caret2.moveToOffset(region2.getEndOffset());
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(NotebookCaretListener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Caret at offset " + offset + " in a non-expandable region (" + region2.getStartOffset() + ":" + region2.getEndOffset() + "). Last action: " + lastAction);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator$NotebookKeyAdapter;", "Ljava/awt/event/KeyAdapter;", "<init>", "(Lcom/intellij/jupyter/core/editor/ui/NotebookCellMarkerDecorator;)V", "keyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.jupyter.core"})
    private final class NotebookKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyPressed(@Nullable KeyEvent e) {
            block2: {
                if (NotebookCellMarkerDecorator.this.editor.getCaretModel().getOffset() != 0) {
                    return;
                }
                FoldRegion foldRegion = NotebookCellMarkerDecorator.this.editor.getFoldingModel().getCollapsedRegionAtOffset(0);
                if (foldRegion == null) break block2;
                FoldRegion foldRegion2 = foldRegion;
                NotebookCellMarkerDecorator notebookCellMarkerDecorator = NotebookCellMarkerDecorator.this;
                FoldRegion it = foldRegion2;
                boolean bl = false;
                if (it.isExpanded() || !it.shouldNeverExpand() || !NotebookCellMarkerDecoratorKt.isCellMarker(it)) {
                    return;
                }
                notebookCellMarkerDecorator.editor.getCaretModel().moveToOffset(it.getEndOffset());
            }
        }
    }
}

