/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.convert;

import com.intellij.jupyter.core.jupyter.convert.JupyterNotebookToHtmlConverterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u001a4\u0010\u0005\u001a\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"ANSI_COLORS", "", "", "ansi2html", "text", "createAnsiSpan", "fg", "", "bg", "bold", "", "underline", "inverse", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nAnsi2Html.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ansi2Html.kt\ncom/intellij/jupyter/core/jupyter/convert/Ansi2HtmlKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1342#2:182\n1343#2:197\n1642#3,10:183\n1915#3:193\n1916#3:195\n1652#3:196\n1#4:194\n*S KotlinDebug\n*F\n+ 1 Ansi2Html.kt\ncom/intellij/jupyter/core/jupyter/convert/Ansi2HtmlKt\n*L\n43#1:182\n43#1:197\n49#1:183,10\n49#1:193\n49#1:195\n49#1:196\n49#1:194\n*E\n"})
public final class Ansi2HtmlKt {
    @NotNull
    private static final List<String> ANSI_COLORS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String ansi2html(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        Regex ansiPattern = new Regex("\u001b\\[([0-9;]*)m");
        Ref.ObjectRef currentFg = new Ref.ObjectRef();
        Ref.ObjectRef currentBg = new Ref.ObjectRef();
        Ref.BooleanRef bold = new Ref.BooleanRef();
        Ref.BooleanRef underline = new Ref.BooleanRef();
        Ref.BooleanRef inverse = new Ref.BooleanRef();
        int lastEnd = 0;
        Ref.BooleanRef openSpan = new Ref.BooleanRef();
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)ansiPattern, (CharSequence)text, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            String textBefore;
            MatchResult match = (MatchResult)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)text.substring(lastEnd, match.getRange().getFirst()), (String)"substring(...)");
            Ansi2HtmlKt.ansi2html$appendTextWithSpan(openSpan, (Ref.ObjectRef<Object>)currentFg, (Ref.ObjectRef<Object>)currentBg, bold, underline, inverse, result2, textBefore);
            char[] cArray = new char[]{';'};
            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)((CharSequence)match.getGroupValues().get(1)), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.toIntOrNull((String)it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List codes = (List)destination$iv$iv;
            block6: for (int i = 0; i < codes.size(); ++i) {
                int code = ((Number)codes.get(i)).intValue();
                if (code == 0) {
                    if (openSpan.element) {
                        result2.append("</span>");
                        openSpan.element = false;
                    }
                    currentFg.element = null;
                    currentBg.element = null;
                    bold.element = false;
                    underline.element = false;
                    inverse.element = false;
                    continue;
                }
                if (code == 1) {
                    bold.element = true;
                    continue;
                }
                if (code == 4) {
                    underline.element = true;
                    continue;
                }
                if (code == 7) {
                    inverse.element = true;
                    continue;
                }
                if (code == 21 || code == 22) {
                    bold.element = false;
                    continue;
                }
                if (code == 24) {
                    underline.element = false;
                    continue;
                }
                if (code == 27) {
                    inverse.element = false;
                    continue;
                }
                boolean bl5 = 30 <= code ? code < 38 : false;
                if (bl5) {
                    currentFg.element = code - 30;
                    continue;
                }
                boolean bl6 = 40 <= code ? code < 48 : false;
                if (bl6) {
                    currentBg.element = code - 40;
                    continue;
                }
                boolean bl7 = 90 <= code ? code < 98 : false;
                if (bl7) {
                    currentFg.element = code - 90 + 8;
                    continue;
                }
                boolean bl8 = 100 <= code ? code < 108 : false;
                if (bl8) {
                    currentBg.element = code - 100 + 8;
                    continue;
                }
                if (code == 38 || code == 48) {
                    if (i + 1 >= codes.size()) continue;
                    switch (((Number)codes.get(i + 1)).intValue()) {
                        case 5: {
                            if (i + 2 >= codes.size()) continue block6;
                            int colorIdx = ((Number)codes.get(i + 2)).intValue();
                            if (colorIdx < 16) {
                                if (code == 38) {
                                    currentFg.element = colorIdx;
                                } else {
                                    currentBg.element = colorIdx;
                                }
                            }
                            i += 2;
                            break;
                        }
                        case 2: {
                            if (i + 4 >= codes.size()) continue block6;
                            Triple rgb = new Triple(codes.get(i + 2), codes.get(i + 3), codes.get(i + 4));
                            if (code == 38) {
                                currentFg.element = rgb;
                            } else {
                                currentBg.element = rgb;
                            }
                            i += 4;
                        }
                    }
                    continue;
                }
                if (code == 39) {
                    currentFg.element = null;
                    continue;
                }
                if (code != 49) continue;
                currentBg.element = null;
            }
            lastEnd = match.getRange().getLast() + 1;
        }
        String string = text.substring(lastEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String remaining = string;
        Ansi2HtmlKt.ansi2html$appendTextWithSpan(openSpan, (Ref.ObjectRef<Object>)currentFg, (Ref.ObjectRef<Object>)currentBg, bold, underline, inverse, result2, remaining);
        if (openSpan.element) {
            result2.append("</span>");
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final String createAnsiSpan(Object fg, Object bg, boolean bold, boolean underline, boolean inverse) {
        Triple rgb;
        Object object;
        if (!(inverse || fg != null || bg != null || bold || underline)) {
            return "";
        }
        List classes = new ArrayList();
        List styles = new ArrayList();
        Object actualFg = fg;
        Object actualBg = bg;
        if (inverse) {
            actualFg = bg;
            actualBg = fg;
        }
        if ((object = actualFg) instanceof Integer) {
            classes.add(ANSI_COLORS.get(((Number)actualFg).intValue()) + "-fg");
        } else if (object instanceof Triple) {
            Object object2 = actualFg;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Triple<kotlin.Int, kotlin.Int, kotlin.Int>");
            rgb = (Triple)object2;
            styles.add("color: rgb(" + rgb.getFirst() + "," + rgb.getSecond() + "," + rgb.getThird() + ")");
        } else if (object == null && inverse) {
            classes.add("ansi-default-inverse-fg");
        }
        object = actualBg;
        if (object instanceof Integer) {
            classes.add(ANSI_COLORS.get(((Number)actualBg).intValue()) + "-bg");
        } else if (object instanceof Triple) {
            Object object3 = actualBg;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Triple<kotlin.Int, kotlin.Int, kotlin.Int>");
            rgb = (Triple)object3;
            styles.add("background-color: rgb(" + rgb.getFirst() + "," + rgb.getSecond() + "," + rgb.getThird() + ")");
        } else if (object == null && inverse) {
            classes.add("ansi-default-inverse-bg");
        }
        if (bold) {
            classes.add("ansi-bold");
        }
        if (underline) {
            classes.add("ansi-underline");
        }
        StringBuilder sb = new StringBuilder("<span");
        if (!((Collection)classes).isEmpty()) {
            sb.append(" class=\"" + CollectionsKt.joinToString$default((Iterable)classes, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\"");
        }
        if (!((Collection)styles).isEmpty()) {
            sb.append(" style=\"" + CollectionsKt.joinToString$default((Iterable)styles, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null) + "\"");
        }
        sb.append(">");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void ansi2html$appendTextWithSpan(Ref.BooleanRef openSpan, Ref.ObjectRef<Object> currentFg, Ref.ObjectRef<Object> currentBg, Ref.BooleanRef bold, Ref.BooleanRef underline, Ref.BooleanRef inverse, StringBuilder result2, String textToAppend) {
        if (((CharSequence)textToAppend).length() > 0) {
            if (!openSpan.element && (currentFg.element != null || currentBg.element != null || bold.element || underline.element || inverse.element)) {
                result2.append(Ansi2HtmlKt.createAnsiSpan(currentFg.element, currentBg.element, bold.element, underline.element, inverse.element));
                openSpan.element = true;
            }
            result2.append(JupyterNotebookToHtmlConverterKt.escapeHtmlKeepQuotes(textToAppend));
        }
    }

    static {
        Object[] objectArray = new String[]{"ansi-black", "ansi-red", "ansi-green", "ansi-yellow", "ansi-blue", "ansi-magenta", "ansi-cyan", "ansi-white", "ansi-black-intense", "ansi-red-intense", "ansi-green-intense", "ansi-yellow-intense", "ansi-blue-intense", "ansi-magenta-intense", "ansi-cyan-intense", "ansi-white-intense"};
        ANSI_COLORS = CollectionsKt.listOf((Object[])objectArray);
    }
}

