/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.convert;

import com.intellij.jupyter.core.jupyter.convert.PageSize;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\nH\u0002\u001a\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"TABLE_REGEX", "Lkotlin/text/Regex;", "THEAD_ROW_REGEX", "TH_CONTENT_REGEX", "THEAD_BLOCK_REGEX", "TR_BLOCK_REGEX", "TH_BLOCK_REGEX", "DOT_SEP_ALNUM_REGEX", "CLASS_ATTR_REGEX", "SHORT_NOWRAP_MAX_PX", "", "DATAFRAME_HPAD_PX", "", "BODY_MARGIN_IN", "HEADER_FONT_SIZE_PT", "annotateTablesForSmartHeaders", "", "html", "pageSize", "Lcom/intellij/jupyter/core/jupyter/convert/PageSize;", "decideHeaderClass", "tableInnerHtml", "availableWidthPx", "maybeAnnotateShortHeaderNoWrap", "addClassToOpeningTag", "openTag", "newClass", "computeAvailablePageWidthPx", "measureHeaderTextPx", "text", "heuristicWidthPx", "fontSizePt", "stripTagsAndDecode", "s", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nSmartTableHeaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartTableHeaders.kt\ncom/intellij/jupyter/core/jupyter/convert/SmartTableHeadersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1#2:178\n1849#3,3:179\n1786#3,3:182\n*S KotlinDebug\n*F\n+ 1 SmartTableHeaders.kt\ncom/intellij/jupyter/core/jupyter/convert/SmartTableHeadersKt\n*L\n82#1:179,3\n112#1:182,3\n*E\n"})
public final class SmartTableHeadersKt {
    @NotNull
    private static final Regex TABLE_REGEX;
    @NotNull
    private static final Regex THEAD_ROW_REGEX;
    @NotNull
    private static final Regex TH_CONTENT_REGEX;
    @NotNull
    private static final Regex THEAD_BLOCK_REGEX;
    @NotNull
    private static final Regex TR_BLOCK_REGEX;
    @NotNull
    private static final Regex TH_BLOCK_REGEX;
    @NotNull
    private static final Regex DOT_SEP_ALNUM_REGEX;
    @NotNull
    private static final Regex CLASS_ATTR_REGEX;
    private static final double SHORT_NOWRAP_MAX_PX = 120.0;
    private static final int DATAFRAME_HPAD_PX = 8;
    private static final double BODY_MARGIN_IN = 0.25;
    private static final double HEADER_FONT_SIZE_PT = 9.0;

    @NotNull
    public static final String annotateTablesForSmartHeaders(@NotNull String html, @NotNull PageSize pageSize) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)((Object)pageSize), (String)"pageSize");
        try {
            boolean bl = false;
            double availableWidthPx = SmartTableHeadersKt.computeAvailablePageWidthPx(pageSize);
            Regex tableRe = TABLE_REGEX;
            StringBuilder sb = new StringBuilder();
            int lastIdx = 0;
            for (MatchResult m : Regex.findAll$default((Regex)tableRe, (CharSequence)html, (int)0, (int)2, null)) {
                sb.append(html, lastIdx, m.getRange().getFirst());
                String openTag = (String)m.getGroupValues().get(1);
                String inner = (String)m.getGroupValues().get(2);
                String closeTag = (String)m.getGroupValues().get(3);
                String className = SmartTableHeadersKt.decideHeaderClass(inner, availableWidthPx);
                if (Intrinsics.areEqual((Object)className, (Object)"wrap-headers")) {
                    inner = SmartTableHeadersKt.maybeAnnotateShortHeaderNoWrap(inner);
                }
                String string = className;
                String newOpen = string != null ? SmartTableHeadersKt.addClassToOpeningTag(openTag, string) : openTag;
                sb.append(newOpen).append(inner).append(closeTag);
                lastIdx = m.getRange().getLast() + 1;
            }
            if (lastIdx == 0) {
                return html;
            }
            sb.append(html, lastIdx, html.length());
            object2 = Result.constructor-impl((Object)sb.toString());
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = html;
        }
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final String decideHeaderClass(String tableInnerHtml, double availableWidthPx) {
        void $this$fold$iv;
        MatchResult matchResult = Regex.find$default((Regex)THEAD_ROW_REGEX, (CharSequence)tableInnerHtml, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult m = matchResult;
        String rowHtml = (String)m.getGroupValues().get(1);
        List headers = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)TH_CONTENT_REGEX, (CharSequence)rowHtml, (int)0, (int)2, null), SmartTableHeadersKt::decideHeaderClass$lambda$0));
        if (headers.isEmpty()) {
            return null;
        }
        Iterable iterable = headers;
        double initial$iv = 0.0;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void h;
            String string = (String)element$iv;
            double acc = accumulator$iv;
            boolean bl = false;
            double w = SmartTableHeadersKt.measureHeaderTextPx((String)h);
            accumulator$iv = acc + w + 16.0;
        }
        double sumPx = accumulator$iv;
        return sumPx <= availableWidthPx ? "nowrap-headers" : "wrap-headers";
    }

    /*
     * Unable to fully structure code
     */
    private static final String maybeAnnotateShortHeaderNoWrap(String tableInnerHtml) {
        v0 = Regex.find$default((Regex)SmartTableHeadersKt.THEAD_BLOCK_REGEX, (CharSequence)tableInnerHtml, (int)0, (int)2, null);
        if (v0 == null) {
            return tableInnerHtml;
        }
        theadMatch = v0;
        thead = theadMatch.getValue();
        v1 = Regex.find$default((Regex)SmartTableHeadersKt.TR_BLOCK_REGEX, (CharSequence)thead, (int)0, (int)2, null);
        if (v1 == null) {
            return tableInnerHtml;
        }
        rowMatch = v1;
        rowOpen = (String)rowMatch.getGroupValues().get(1);
        rowInner = (String)rowMatch.getGroupValues().get(2);
        rowClose = (String)rowMatch.getGroupValues().get(3);
        newRowInner = new StringBuilder();
        last = 0;
        for (MatchResult m : Regex.findAll$default((Regex)SmartTableHeadersKt.TH_BLOCK_REGEX, (CharSequence)rowInner, (int)0, (int)2, null)) {
            block9: {
                newRowInner.append(rowInner, last, m.getRange().getFirst());
                thOpen = (String)m.getGroupValues().get(1);
                thContent = (String)m.getGroupValues().get(2);
                thClose = (String)m.getGroupValues().get(3);
                plain = SmartTableHeadersKt.stripTagsAndDecode(thContent);
                width = SmartTableHeadersKt.measureHeaderTextPx(plain) + 16.0;
                if (!(width <= 120.0) || !StringsKt.contains$default((CharSequence)plain, (char)'.', (boolean)false, (int)2, null) || !SmartTableHeadersKt.DOT_SEP_ALNUM_REGEX.matches((CharSequence)plain)) ** GOTO lbl-1000
                var18_17 = new char[]{'.'};
                $this$all$iv = StringsKt.split$default((CharSequence)plain, (char[])var18_17, (boolean)false, (int)0, (int)6, null);
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v2 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (String)element$iv;
                        $i$a$-all-SmartTableHeadersKt$maybeAnnotateShortHeaderNoWrap$isShortDotSeparated$1 = false;
                        if (((CharSequence)it).length() > 0) continue;
                        v2 = false;
                        break block9;
                    }
                    v2 = true;
                }
            }
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            isShortDotSeparated = v3;
            thOpenUpdated = isShortDotSeparated != false ? SmartTableHeadersKt.addClassToOpeningTag(thOpen, "th-nobr") : thOpen;
            newRowInner.append(thOpenUpdated).append(thContent).append(thClose);
            last = m.getRange().getLast() + 1;
        }
        if (last == 0) {
            return tableInnerHtml;
        }
        newRowInner.append(rowInner, last, rowInner.length());
        newRow = rowOpen + newRowInner + rowClose;
        var11_11 = thead;
        var12_12 = rowMatch.getRange();
        newThead = StringsKt.replaceRange((CharSequence)var11_11, (IntRange)var12_12, (CharSequence)newRow).toString();
        var11_11 = tableInnerHtml;
        var12_12 = theadMatch.getRange();
        return StringsKt.replaceRange((CharSequence)var11_11, (IntRange)var12_12, (CharSequence)newThead).toString();
    }

    private static final String addClassToOpeningTag(String openTag, String newClass) {
        Object object;
        MatchResult m = Regex.find$default((Regex)CLASS_ATTR_REGEX, (CharSequence)openTag, (int)0, (int)2, null);
        if (m != null) {
            String quote = (String)m.getGroupValues().get(1);
            String existing = (String)m.getGroupValues().get(2);
            String string = openTag;
            IntRange intRange = m.getRange();
            CharSequence charSequence = "class=" + quote + existing + " " + newClass + quote;
            object = ((Object)StringsKt.replaceRange((CharSequence)string, (IntRange)intRange, (CharSequence)charSequence)).toString();
        } else {
            int idx = StringsKt.lastIndexOf$default((CharSequence)openTag, (char)'>', (int)0, (boolean)false, (int)6, null);
            if (idx >= 0) {
                String string = openTag.substring(0, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = openTag.substring(idx);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string + " class=\"" + newClass + "\"" + string2;
            } else {
                object = openTag;
            }
        }
        return object;
    }

    private static final double computeAvailablePageWidthPx(PageSize pageSize) {
        double pageWidthIn = switch (WhenMappings.$EnumSwitchMapping$0[pageSize.ordinal()]) {
            case 1 -> 8.267716535433072;
            case 2 -> 8.5;
            default -> throw new NoWhenBranchMatchedException();
        };
        double pxPerIn = 96.0;
        double pagePx = pageWidthIn * pxPerIn;
        double bodyMarginPx = 0.25 * pxPerIn;
        return RangesKt.coerceAtLeast((double)(pagePx - (double)2 * bodyMarginPx), (double)100.0);
    }

    private static final double measureHeaderTextPx(String text) {
        double fontSizePt = 9.0;
        return SmartTableHeadersKt.heuristicWidthPx(text, fontSizePt);
    }

    private static final double heuristicWidthPx(String text, double fontSizePt) {
        double pxPerPt = 1.3333333333333333;
        double fontSizePx = fontSizePt * pxPerPt;
        return (double)text.length() * 0.56 * fontSizePx;
    }

    private static final String stripTagsAndDecode(String s) {
        CharSequence charSequence = s;
        Regex regex = new Regex("<[^>]+>");
        String string = "";
        String noTags = regex.replace(charSequence, string);
        return ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)noTags, (String)"&nbsp;", (String)" ", (boolean)false, (int)4, null), (String)"&lt;", (String)"<", (boolean)false, (int)4, null), (String)"&gt;", (String)">", (boolean)false, (int)4, null), (String)"&quot;", (String)"\"", (boolean)false, (int)4, null), (String)"&#39;", (String)"'", (boolean)false, (int)4, null), (String)"&amp;", (String)"&", (boolean)false, (int)4, null))).toString();
    }

    private static final String decideHeaderClass$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SmartTableHeadersKt.stripTagsAndDecode((String)it.getGroupValues().get(1));
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        TABLE_REGEX = new Regex("(<table\\b[^>]*>)([\\s\\S]*?)(</table>)", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        THEAD_ROW_REGEX = new Regex("<thead[^>]*>[\\s\\S]*?<tr[^>]*>([\\s\\S]*?)</tr>[\\s\\S]*?</thead>", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        TH_CONTENT_REGEX = new Regex("<th[^>]*>([\\s\\S]*?)</th>", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        THEAD_BLOCK_REGEX = new Regex("(<thead[^>]*>[\\s\\S]*?</thead>)", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        TR_BLOCK_REGEX = new Regex("(<tr[^>]*>)([\\s\\S]*?)(</tr>)", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        TH_BLOCK_REGEX = new Regex("(<th[^>]*>)([\\s\\S]*?)(</th>)", SetsKt.setOf((Object[])objectArray));
        DOT_SEP_ALNUM_REGEX = new Regex("^[A-Za-z0-9.]+$");
        CLASS_ATTR_REGEX = new Regex("class\\s*=\\s*([\"'])([^\"']*)([\"'])", SetsKt.setOf((Object)RegexOption.IGNORE_CASE));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PageSize.values().length];
            try {
                nArray[PageSize.A4.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PageSize.Letter.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

